import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { PureComponent } from 'react';
import { clearButtonStyles } from '../Button/Button.mjs';
import '../Button/ButtonGroup.mjs';
import { FormattedValueDisplay } from '../FormattedValueDisplay/FormattedValueDisplay.mjs';
import { buildLayout } from './BigValueLayout.mjs';
import { PercentChange } from './PercentChange.mjs';

var BigValueColorMode = /* @__PURE__ */ ((BigValueColorMode2) => {
  BigValueColorMode2["Background"] = "background";
  BigValueColorMode2["BackgroundSolid"] = "background_solid";
  BigValueColorMode2["None"] = "none";
  BigValueColorMode2["Value"] = "value";
  return BigValueColorMode2;
})(BigValueColorMode || {});
var BigValueGraphMode = /* @__PURE__ */ ((BigValueGraphMode2) => {
  BigValueGraphMode2["None"] = "none";
  BigValueGraphMode2["Line"] = "line";
  BigValueGraphMode2["Area"] = "area";
  return BigValueGraphMode2;
})(BigValueGraphMode || {});
var BigValueJustifyMode = /* @__PURE__ */ ((BigValueJustifyMode2) => {
  BigValueJustifyMode2["Auto"] = "auto";
  BigValueJustifyMode2["Center"] = "center";
  return BigValueJustifyMode2;
})(BigValueJustifyMode || {});
var BigValueTextMode = /* @__PURE__ */ ((BigValueTextMode2) => {
  BigValueTextMode2["Auto"] = "auto";
  BigValueTextMode2["Value"] = "value";
  BigValueTextMode2["ValueAndName"] = "value_and_name";
  BigValueTextMode2["Name"] = "name";
  BigValueTextMode2["None"] = "none";
  return BigValueTextMode2;
})(BigValueTextMode || {});
class BigValue extends PureComponent {
  render() {
    const { onClick, className, hasLinks, theme } = this.props;
    const layout = buildLayout(this.props);
    const panelStyles = layout.getPanelStyles();
    const valueAndTitleContainerStyles = layout.getValueAndTitleContainerStyles();
    const valueStyles = layout.getValueStyles();
    const titleStyles = layout.getTitleStyles();
    const textValues = layout.textValues;
    const percentChange = this.props.value.percentChange;
    const percentChangeColorMode = this.props.percentChangeColorMode;
    const showPercentChange = percentChange != null && !Number.isNaN(percentChange);
    const tooltip = hasLinks ? undefined : textValues.tooltip;
    if (!onClick) {
      return /* @__PURE__ */ jsxs("div", { className, style: panelStyles, title: tooltip, children: [
        /* @__PURE__ */ jsxs("div", { style: valueAndTitleContainerStyles, children: [
          textValues.title && /* @__PURE__ */ jsx("div", { style: titleStyles, children: textValues.title }),
          /* @__PURE__ */ jsx(FormattedValueDisplay, { value: textValues, style: valueStyles }),
          showPercentChange && /* @__PURE__ */ jsx(
            PercentChange,
            {
              percentChange,
              styles: layout.getPercentChangeStyles(percentChange, percentChangeColorMode, valueStyles)
            }
          )
        ] }),
        layout.renderChart()
      ] });
    }
    return /* @__PURE__ */ jsxs(
      "button",
      {
        type: "button",
        className: cx(clearButtonStyles(theme), className),
        style: panelStyles,
        onClick,
        title: tooltip,
        children: [
          /* @__PURE__ */ jsxs("div", { style: valueAndTitleContainerStyles, children: [
            textValues.title && /* @__PURE__ */ jsx("div", { style: titleStyles, children: textValues.title }),
            /* @__PURE__ */ jsx(FormattedValueDisplay, { value: textValues, style: valueStyles })
          ] }),
          layout.renderChart()
        ]
      }
    );
  }
}
BigValue.defaultProps = {
  justifyMode: "auto" /* Auto */
};

export { BigValue, BigValueColorMode, BigValueGraphMode, BigValueJustifyMode, BigValueTextMode };
//# sourceMappingURL=BigValue.mjs.map
