import { jsx, jsxs } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import * as React from 'react';
import { formattedValueToString } from '@grafana/data';
import { TableCellDisplayMode } from '@grafana/schema';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import '../../utils/dom.mjs';
import '../../utils/colors.mjs';
import 'slate';
import { getCellLinks } from '../../utils/table.mjs';
import 'lodash';
import '../../utils/logger.mjs';
import { clearLinkButtonStyles } from '../Button/Button.mjs';
import '../Button/ButtonGroup.mjs';
import { DataLinksContextMenu } from '../DataLinks/DataLinksContextMenu.mjs';
import { CellActions } from './CellActions.mjs';
import { TableCellInspectorMode } from './TableCellInspector.mjs';
import { getCellOptions, getCellColors } from './utils.mjs';

const DefaultCell = (props) => {
  var _a, _b, _c;
  const { field, cell, tableStyles, row, cellProps, frame, rowStyled, rowExpanded, textWrapped, height } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? undefined : _a.inspect);
  const displayValue = field.display(cell.value);
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== undefined || inspectEnabled;
  const cellOptions = getCellOptions(field);
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? undefined : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  let value;
  const OG_TWEET_LENGTH = 140;
  if (cellOptions.type === TableCellDisplayMode.Custom) {
    const CustomCellComponent = cellOptions.cellComponent;
    value = /* @__PURE__ */ jsx(CustomCellComponent, { field, value: cell.value, rowIndex: row.index, frame });
  } else {
    if (React.isValidElement(cell.value)) {
      value = cell.value;
    } else {
      value = formattedValueToString(displayValue);
    }
  }
  const isStringValue = typeof value === "string";
  const textShouldWrap = displayValue.text.length <= OG_TWEET_LENGTH && /\s/.test(displayValue.text);
  const cellStyle = getCellStyle(
    tableStyles,
    cellOptions,
    displayValue,
    inspectEnabled,
    isStringValue,
    textShouldWrap,
    textWrapped,
    rowStyled,
    rowExpanded
  );
  if (isStringValue) {
    let justifyContent = (_c = cellProps.style) == null ? undefined : _c.justifyContent;
    if (justifyContent === "flex-end") {
      cellProps.style = { ...cellProps.style, textAlign: "right" };
    } else if (justifyContent === "center") {
      cellProps.style = { ...cellProps.style, textAlign: "center" };
    }
  }
  if (height) {
    cellProps.style = { ...cellProps.style, height };
  }
  if (textWrapped) {
    cellProps.style = { ...cellProps.style, textWrap: "wrap" };
  }
  const { key, ...rest } = cellProps;
  return /* @__PURE__ */ jsxs("div", { ...rest, className: cellStyle, children: [
    hasLinks ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [], children: (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ jsx(
          "button",
          {
            className: cx(clearButtonStyle, getLinkStyle(tableStyles, cellOptions, api.targetClassName)),
            onClick: api.openMenu,
            children: value
          }
        );
      } else {
        return /* @__PURE__ */ jsx("div", { className: getLinkStyle(tableStyles, cellOptions, api.targetClassName), children: value });
      }
    } }) : isStringValue ? `${value}` : /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, children: value }),
    showActions && /* @__PURE__ */ jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.text, showFilters })
  ] }, key);
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false, isStringValue = false, shouldWrapText = false, textWrapped = false, rowStyled = false, rowExpanded = false) {
  let textColor = undefined;
  let bgColor = undefined;
  let bgHoverColor = undefined;
  const colors = getCellColors(tableStyles, cellOptions, displayValue);
  textColor = colors.textColor;
  bgColor = colors.bgColor;
  bgHoverColor = colors.bgHoverColor;
  return tableStyles.buildCellContainerStyle(
    textColor,
    bgColor,
    bgHoverColor,
    !disableOverflowOnHover,
    isStringValue,
    shouldWrapText,
    textWrapped,
    rowStyled,
    rowExpanded
  );
}
function getLinkStyle(tableStyles, cellOptions, targetClassName) {
  if (cellOptions.type === TableCellDisplayMode.Auto) {
    return cx(tableStyles.cellLink, targetClassName);
  }
  return cx(tableStyles.cellLinkForColoredCell, targetClassName);
}

export { DefaultCell };
//# sourceMappingURL=DefaultCell.mjs.map
