import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { getResponsiveStyle } from '../utils/responsiveness.mjs';
import { getSizeStyles } from '../utils/styles.mjs';

const Stack = React.forwardRef((props, ref) => {
  const {
    gap = 1,
    alignItems,
    justifyContent,
    direction,
    wrap,
    children,
    grow,
    shrink,
    basis,
    flex,
    width,
    minWidth,
    maxWidth,
    height,
    minHeight,
    maxHeight,
    ...rest
  } = props;
  const styles = useStyles2(getStyles, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex);
  const sizeStyles = useStyles2(getSizeStyles, width, minWidth, maxWidth, height, minHeight, maxHeight);
  return /* @__PURE__ */ jsx("div", { ref, className: cx(styles.flex, sizeStyles), ...rest, children });
});
Stack.displayName = "Stack";
const getStyles = (theme, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex) => {
  return {
    flex: css([
      {
        display: "flex"
      },
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, wrap, (val) => ({
        flexWrap: typeof val === "boolean" ? val ? "wrap" : "nowrap" : val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      }))
    ])
  };
};

export { Stack };
//# sourceMappingURL=Stack.mjs.map
