import { map } from 'rxjs/operators';
import { getTimeField } from '../../dataframe/processDataFrame.mjs';
import { DataTransformerID } from './ids.mjs';
import { joinByFieldTransformer } from './joinByField.mjs';

const ensureColumnsTransformer = {
  id: DataTransformerID.ensureColumns,
  name: "Ensure Columns Transformer",
  description: "Will check if current data frames is series or columns. If in series it will convert to columns.",
  operator: (options, ctx) => (source) => source.pipe(map((data) => ensureColumnsTransformer.transformer(options, ctx)(data))),
  transformer: (_options, ctx) => (frames) => {
    const timeFieldName = findConsistentTimeFieldName(frames);
    if (frames.length > 1 && timeFieldName) {
      return joinByFieldTransformer.transformer(
        {
          byField: timeFieldName
        },
        ctx
      )(frames);
    }
    return frames;
  }
};
function findConsistentTimeFieldName(data) {
  let name = undefined;
  for (const frame of data) {
    const { timeField } = getTimeField(frame);
    if (!timeField) {
      return undefined;
    }
    if (!name) {
      name = timeField.name;
    } else if (name !== timeField.name) {
      return undefined;
    }
  }
  return name;
}

export { ensureColumnsTransformer };
//# sourceMappingURL=ensureColumns.mjs.map
