import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const TabContent = ({ children, className, ...restProps }) => {
  const styles = useStyles2(getTabContentStyle);
  return /* @__PURE__ */ jsx("div", { ...restProps, className: cx(styles.tabContent, className), children });
};
const getTabContentStyle = (theme) => ({
  tabContent: css({
    background: theme.colors.background.primary
  })
});

export { TabContent };
//# sourceMappingURL=TabContent.js.map
