import { jsxs, jsx } from 'react/jsx-runtime';
import { useStyles2 } from '../../themes/ThemeContext.js';
import { getSelectStyles } from './getSelectStyles.js';

const SelectOptionGroup = ({
  children,
  cx,
  getClassNames,
  getStyles,
  Heading,
  headingProps,
  label,
  selectProps,
  theme
}) => {
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.group, children: [
    /* @__PURE__ */ jsx(
      Heading,
      {
        cx,
        getClassNames,
        getStyles,
        selectProps,
        theme,
        ...headingProps,
        children: label
      }
    ),
    children
  ] });
};

export { SelectOptionGroup };
//# sourceMappingURL=SelectOptionGroup.js.map
