import { jsx } from 'react/jsx-runtime';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';

function DataLinkButton({ link, buttonProps }) {
  return /* @__PURE__ */ jsx(
    "a",
    {
      href: link.href,
      target: link.target,
      rel: "noreferrer",
      onClick: link.onClick ? (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey) && link.onClick) {
          event.preventDefault();
          link.onClick(event);
        }
      } : void 0,
      children: /* @__PURE__ */ jsx(
        Button,
        {
          icon: link.target === "_blank" ? "external-link-alt" : "link",
          variant: "primary",
          size: "sm",
          ...buttonProps,
          children: link.title
        }
      )
    }
  );
}

export { DataLinkButton };
//# sourceMappingURL=DataLinkButton.js.map
