import { config } from '../../config.js';

function createPluginEventProperties(meta) {
  return {
    grafana_version: config.buildInfo.version,
    plugin_type: String(meta.type),
    plugin_version: meta.info.version,
    plugin_id: meta.id,
    plugin_name: meta.name
  };
}
function createDataSourcePluginEventProperties(instanceSettings) {
  return {
    ...createPluginEventProperties(instanceSettings.meta),
    datasource_uid: instanceSettings.uid
  };
}

export { createDataSourcePluginEventProperties, createPluginEventProperties };
//# sourceMappingURL=eventProperties.js.map
