import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState, useEffect } from 'react';
import { reportInteraction } from '@grafana/runtime';
import { useStyles2, Tooltip, Button } from '@grafana/ui';

function QueryEditorHints(props) {
  const [hints, setHints] = useState([]);
  const { query, data, datasource } = props;
  const styles = useStyles2(getStyles);
  useEffect(() => {
    const promQuery = { expr: query.expr, refId: query.refId };
    const hints2 = datasource.getQueryHints(promQuery, (data == null ? void 0 : data.series) || []).filter((hint) => {
      var _a;
      return (_a = hint.fix) == null ? void 0 : _a.action;
    });
    setHints(hints2);
  }, [datasource, data, query]);
  return /* @__PURE__ */ jsx(Fragment, { children: hints.length > 0 && /* @__PURE__ */ jsx("div", { className: styles.container, children: hints.map((hint) => {
    var _a, _b, _c, _d;
    return /* @__PURE__ */ jsx(Tooltip, { content: `${hint.label} ${(_a = hint.fix) == null ? void 0 : _a.label}`, children: /* @__PURE__ */ jsxs(Button, { onClick: () => onHintButtonClick(hint, props), fill: "outline", size: "sm", className: styles.hint, children: [
      "hint: ",
      ((_b = hint.fix) == null ? void 0 : _b.title) || ((_d = (_c = hint.fix) == null ? void 0 : _c.action) == null ? void 0 : _d.type.toLowerCase().replace("_", " "))
    ] }) }, hint.type);
  }) }) });
}
function onHintButtonClick(hint, props) {
  var _a;
  reportInteraction("grafana_query_builder_hints_clicked", {
    hint: hint.type,
    datasourceType: props.datasource.type
  });
  if ((_a = hint.fix) == null ? void 0 : _a.action) {
    const newQuery = props.datasource.modifyQuery(props.query, hint.fix.action);
    return props.onChange(newQuery);
  }
}
const getStyles = (theme) => {
  return {
    container: css({
      display: "flex",
      alignItems: "start"
    }),
    hint: css({
      marginRight: theme.spacing(1),
      padEnd: theme.spacing(2)
    })
  };
};

export { QueryEditorHints };
//# sourceMappingURL=QueryEditorHints.js.map
