import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo, useState, useEffect } from 'react';
import { EditorRow } from '@grafana/experimental';
import { config } from '@grafana/runtime';
import { Drawer } from '@grafana/ui';
import { promqlGrammar } from '../../promql.js';
import { promQueryModeller } from '../PromQueryModeller.js';
import { buildVisualQueryFromString } from '../parsing.js';
import { OperationExplainedBox } from '../shared/OperationExplainedBox.js';
import { OperationList } from '../shared/OperationList.js';
import { OperationListExplained } from '../shared/OperationListExplained.js';
import { OperationsEditorRow } from '../shared/OperationsEditorRow.js';
import { QueryBuilderHints } from '../shared/QueryBuilderHints.js';
import { RawQuery } from '../shared/RawQuery.js';
import { MetricsLabelsSection } from './MetricsLabelsSection.js';
import { NestedQueryList } from './NestedQueryList.js';
import { EXPLAIN_LABEL_FILTER_CONTENT } from './PromQueryBuilderExplained.js';
import { PromQail } from './promQail/PromQail.js';
import { QueryAssistantButton } from './promQail/QueryAssistantButton.js';
import { isLLMPluginEnabled } from './promQail/state/helpers.js';
import { selectors } from '../../grafana-e2e-selectors/src/selectors/index.js';

const PromQueryBuilder = memo((props) => {
  const { datasource, query, onChange, onRunQuery, data, showExplain } = props;
  const [highlightedOp, setHighlightedOp] = useState();
  const [showDrawer, setShowDrawer] = useState(false);
  const [llmAppEnabled, updateLlmAppEnabled] = useState(false);
  const { prometheusPromQAIL } = config.featureToggles;
  const lang = { grammar: promqlGrammar, name: "promql" };
  const initHints = datasource.getInitHints();
  useEffect(() => {
    async function checkLlms() {
      const check = await isLLMPluginEnabled();
      updateLlmAppEnabled(check);
    }
    if (prometheusPromQAIL) {
      checkLlms();
    }
  }, [prometheusPromQAIL]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    prometheusPromQAIL && showDrawer && /* @__PURE__ */ jsx(Drawer, { closeOnMaskClick: false, onClose: () => setShowDrawer(false), children: /* @__PURE__ */ jsx(
      PromQail,
      {
        query,
        closeDrawer: () => setShowDrawer(false),
        onChange,
        datasource
      }
    ) }),
    /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(MetricsLabelsSection, { query, onChange, datasource }) }),
    initHints.length ? /* @__PURE__ */ jsx(
      "div",
      {
        className: css({
          flexBasis: "100%"
        }),
        children: /* @__PURE__ */ jsxs("div", { className: "text-warning", children: [
          initHints[0].label,
          " ",
          initHints[0].fix ? /* @__PURE__ */ jsx("button", { type: "button", className: "text-warning", children: initHints[0].fix.label }) : null
        ] })
      }
    ) : null,
    showExplain && /* @__PURE__ */ jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsx(RawQuery, { query: `${query.metric} ${promQueryModeller.renderLabels(query.labels)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsxs(OperationsEditorRow, { children: [
      /* @__PURE__ */ jsx(
        OperationList,
        {
          queryModeller: promQueryModeller,
          datasource,
          query,
          onChange,
          onRunQuery,
          highlightedOp
        }
      ),
      prometheusPromQAIL && /* @__PURE__ */ jsx(
        "div",
        {
          className: css({
            padding: "0 0 0 6px"
          }),
          children: /* @__PURE__ */ jsx(QueryAssistantButton, { llmAppEnabled, metric: query.metric, setShowDrawer })
        }
      ),
      /* @__PURE__ */ jsx("div", { "data-testid": selectors.components.DataSource.Prometheus.queryEditor.builder.hints, children: /* @__PURE__ */ jsx(
        QueryBuilderHints,
        {
          datasource,
          query,
          onChange,
          data,
          queryModeller: promQueryModeller,
          buildVisualQueryFromString
        }
      ) })
    ] }),
    showExplain && /* @__PURE__ */ jsx(
      OperationListExplained,
      {
        lang,
        query,
        stepNumber: 2,
        queryModeller: promQueryModeller,
        onMouseEnter: (op) => setHighlightedOp(op),
        onMouseLeave: () => setHighlightedOp(void 0)
      }
    ),
    query.binaryQueries && query.binaryQueries.length > 0 && /* @__PURE__ */ jsx(
      NestedQueryList,
      {
        query,
        datasource,
        onChange,
        onRunQuery,
        showExplain
      }
    )
  ] });
});
PromQueryBuilder.displayName = "PromQueryBuilder";

export { PromQueryBuilder };
//# sourceMappingURL=PromQueryBuilder.js.map
