function matchPluginId(idToMatch, pluginMeta) {
  if (pluginMeta.id === idToMatch) {
    return true;
  }
  if (isPromFlavor(idToMatch)) {
    return isPromFlavor(pluginMeta.id);
  }
  if (pluginMeta.aliasIDs) {
    return pluginMeta.aliasIDs.includes(idToMatch);
  }
  return false;
}
function isPromFlavor(pluginId) {
  if (pluginId === "prometheus") {
    return true;
  }
  const regex = new RegExp("^grafana-[0-9a-z]+prometheus-datasource$");
  return regex.test(pluginId);
}

export { matchPluginId };
//# sourceMappingURL=matchPluginId.js.map
