import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { memo } from 'react';
import { v4 } from 'uuid';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import { getFocusStyles } from '../../../themes/mixins.js';

const getStyles = (theme) => {
  return {
    container: css({
      display: "flex",
      alignItems: "center",
      flexDirection: "row-reverse",
      justifyContent: "space-between"
    }),
    selected: css({
      background: theme.colors.action.selected,
      fontWeight: theme.typography.fontWeightMedium
    }),
    radio: css({
      opacity: 0,
      width: "0 !important",
      "&:focus-visible + label": getFocusStyles(theme)
    }),
    label: css({
      cursor: "pointer",
      flex: 1,
      padding: "7px 9px 7px 9px",
      "&:hover": {
        background: theme.colors.action.hover,
        cursor: "pointer"
      }
    })
  };
};
const TimeRangeOption = memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles);
  const id = v4();
  return /* @__PURE__ */ jsxs("li", { className: cx(styles.container, selected && styles.selected), children: [
    /* @__PURE__ */ jsx(
      "input",
      {
        className: styles.radio,
        checked: selected,
        name,
        type: "checkbox",
        "data-role": "item",
        tabIndex: -1,
        id,
        onChange: () => onSelect(value)
      }
    ),
    /* @__PURE__ */ jsx("label", { className: styles.label, htmlFor: id, children: value.display })
  ] });
});
TimeRangeOption.displayName = "TimeRangeOption";

export { TimeRangeOption };
//# sourceMappingURL=TimeRangeOption.js.map
