import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { ConfigSubSection } from '@grafana/experimental';
import { config } from '@grafana/runtime';
import { useTheme2, InlineField, Switch } from '@grafana/ui';
import { overhaulStyles, docsTip } from './ConfigEditor.js';
import { selectors } from '../grafana-e2e-selectors/src/selectors/index.js';

function AlertingSettingsOverhaul({
  options,
  onOptionsChange
}) {
  var _a;
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsx(ConfigSubSection, { title: "Alerting", className: cx(styles.container, styles.alertingTop), children: /* @__PURE__ */ jsx("div", { className: "gf-form-group", children: /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
    InlineField,
    {
      labelWidth: 30,
      label: "Manage alerts via Alerting UI",
      disabled: options.readOnly,
      tooltip: /* @__PURE__ */ jsxs(Fragment, { children: [
        "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source. ",
        docsTip()
      ] }),
      interactive: true,
      className: styles.switchField,
      children: /* @__PURE__ */ jsx(
        Switch,
        {
          value: (_a = options.jsonData.manageAlerts) != null ? _a : config.defaultDatasourceManageAlertsUiToggle,
          onChange: (event) => onOptionsChange({
            ...options,
            jsonData: { ...options.jsonData, manageAlerts: event.currentTarget.checked }
          }),
          id: selectors.components.DataSource.Prometheus.configPage.manageAlerts
        }
      )
    }
  ) }) }) }) });
}

export { AlertingSettingsOverhaul };
//# sourceMappingURL=AlertingSettingsOverhaul.js.map
