---
description: Feature and improvement highlights for Grafana v11.5
keywords:
  - grafana
  - new
  - documentation
  - '11.5'
  - release notes
labels:
products:
  - cloud
  - enterprise
  - oss
title: What's new in Grafana v11.5
posts:
  - title: Cloud Migration Assistant
    items:
      - /whats-new/2025-01-10-grafana-cloud-migration-assistant-supports-all-plugins-and-grafana-alerting.md
  - title: Dashboards and visualizations
    items:
      - /whats-new/2024-10-16-redesigned-ad-hoc-filters-for-dashboards.md
      - /whats-new/2024-11-19-new-regular-expression-option-for-extract-fields-transformation.md
      - /whats-new/2024-09-04-sharing-drawer.md
      - /whats-new/2024-12-16-customizable-shareable-dashboard-panel-images.md
  - title: Reporting
    items:
      - /whats-new/2024-10-21-theme-options-for-reporting.md
      - /whats-new/2024-12-02-pdf-export-improvements-in-ga.md
  - title: Alerting
    items:
      - /whats-new/2025-01-22-rbac-for-alerting-notifications.md
      - /whats-new/2025-01-22-rbac-for-notification-policies.md
  - title: Data sources
    items:
      - /whats-new/2025-01-09-elasticsearch-cross-cluster-search-support.md
      - /whats-new/2024-11-12-open-search-datasource-now-supports-private-datasource-connect.md
      - /whats-new/2024-12-04-time-series-macro-support-in-visual-query-builder-for-sql-data-sources.md
  - title: Authentication and authorization
    items:
      - /whats-new/2025-01-07-oauth-and-saml-session-handling-improvements.md
  - title: Plugins
    items:
      - /whats-new/2025-01-10-plugin-frontend-sandbox.md
  - title: Public dashboards
    items:
      - /whats-new/2024-09-09-public-dashboards-are-now-shared-dashboards.md
whats_new_grafana_version: 11.5
weight: -47
---

# What’s new in Grafana v11.5

Welcome to Grafana 11.5!
Read on to learn about new sharing, reporting, and export options, cross-cluster search for Elasticsearch, PDC support for several new data sources, and more.
The Grafana Cloud Migration Assistant is in public preview and now supports all plugins and Grafana Alerts, in addition to dashboards, folders, and data sources.
We've also made it more secure to run third-party apps and data sources, and improved user session handling for OAuth 2.0 and SAML.

{{< youtube id="RGiktzfhRd0" >}}

For even more detail about all the changes in this release, refer to the [changelog](https://github.com/grafana/grafana/blob/main/CHANGELOG.md). For the specific steps we recommend when you upgrade to v11.5, check out our [Upgrade Guide](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/upgrade-guide/upgrade-v11.5/).

{{< docs/whats-new  >}}
