import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { Trans } from '../../../utils/i18n.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import { Modal } from '../../Modal/Modal.js';
import { DataLinkEditor } from '../DataLinkEditor.js';

const DataLinkEditorModalContent = ({
  link,
  index,
  getSuggestions,
  onSave,
  onCancel
}) => {
  const [dirtyLink, setDirtyLink] = useState(link);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      DataLinkEditor,
      {
        value: dirtyLink,
        index,
        isLast: false,
        suggestions: getSuggestions(),
        onChange: (index2, link2) => {
          setDirtyLink(link2);
        }
      }
    ),
    /* @__PURE__ */ jsxs(Modal.ButtonRow, { children: [
      /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: () => onCancel(index), fill: "outline", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-link-editor-modal.cancel", children: "Cancel" }) }),
      /* @__PURE__ */ jsx(
        Button,
        {
          onClick: () => {
            onSave(index, dirtyLink);
          },
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-link-editor-modal.save", children: "Save" })
        }
      )
    ] })
  ] });
};

export { DataLinkEditorModalContent };
//# sourceMappingURL=DataLinkEditorModalContent.js.map
