import { config } from '../config.js';
import { getBackendSrv } from '../services/backendSrv.js';
import '@grafana/data';
import '../services/LocationService.js';
import '../services/appEvents.js';
import '../services/SidecarService_EXPERIMENTAL.js';
import '../services/SidecarContext_EXPERIMENTAL.js';
import 'react';
import '../services/ScopesContext.js';
import { DataSourceWithBackend } from './DataSourceWithBackend.js';

function isMigrationHandler(object) {
  return object instanceof DataSourceWithBackend && "hasBackendMigration" in object && "shouldMigrate" in object;
}
async function postMigrateRequest(queries) {
  var _a, _b;
  if (!(config.featureToggles.grafanaAPIServerWithExperimentalAPIs || config.featureToggles.datasourceAPIServers)) {
    console.warn("migrateQuery is only available with the experimental API server");
    return queries;
  }
  const dsnameURL = (_b = (_a = queries[0].datasource) == null ? void 0 : _a.type) == null ? void 0 : _b.replace(/^(grafana-)?(.*?)(-datasource)?$/, "$2");
  const groupName = `${dsnameURL}.datasource.grafana.app`;
  const apiVersion = "v0alpha1";
  const url = `/apis/${groupName}/${apiVersion}/namespaces/${config.namespace}/queryconvert`;
  const request = {
    queries: queries.map((query) => {
      return {
        ...query,
        JSON: query
        // JSON is not part of the type but it should be what holds the query
      };
    })
  };
  const res = await getBackendSrv().post(url, request);
  return res.queries.map((query) => query.JSON);
}
async function migrateQuery(datasource, query) {
  if (!datasource.hasBackendMigration || !datasource.shouldMigrate(query)) {
    return query;
  }
  const res = await postMigrateRequest([query]);
  return res[0];
}
async function migrateRequest(datasource, request) {
  if (!datasource.hasBackendMigration || !request.targets.some((query) => datasource.shouldMigrate(query))) {
    return request;
  }
  const res = await postMigrateRequest(request.targets);
  return { ...request, targets: res };
}

export { isMigrationHandler, migrateQuery, migrateRequest };
//# sourceMappingURL=migrationHandler.js.map
