import { store, CoreApp } from '@grafana/data';
import { LegendFormatMode } from '../types.js';
import { QueryEditorMode } from './shared/types.js';

const queryEditorModeDefaultLocalStorageKey = "PrometheusQueryEditorModeDefault";
function changeEditorMode(query, editorMode, onChange) {
  if (query.expr === "") {
    store.set(queryEditorModeDefaultLocalStorageKey, editorMode);
  }
  onChange({ ...query, editorMode });
}
function getDefaultEditorMode(expr, defaultEditor = QueryEditorMode.Builder) {
  if (expr != null && expr !== "") {
    return QueryEditorMode.Code;
  }
  const value = store.get(queryEditorModeDefaultLocalStorageKey);
  switch (value) {
    case QueryEditorMode.Builder:
    case QueryEditorMode.Code:
      return value;
    default:
      return defaultEditor;
  }
}
function getQueryWithDefaults(query, app, defaultEditor) {
  let result = query;
  if (!query.editorMode) {
    result = { ...query, editorMode: getDefaultEditorMode(query.expr, defaultEditor) };
  }
  if (!query.expr) {
    result = { ...result, expr: "", legendFormat: LegendFormatMode.Auto };
  }
  if (query.range == null && query.instant == null) {
    result = { ...result, range: true };
    if (app === CoreApp.Explore) {
      result.instant = true;
    }
  }
  const isBothInstantAndRange = query.instant && query.range;
  if (app === CoreApp.UnifiedAlerting && isBothInstantAndRange) {
    result = { ...result, instant: false, range: true };
  }
  return result;
}

export { changeEditorMode, getQueryWithDefaults };
//# sourceMappingURL=state.js.map
