import { jsx } from 'react/jsx-runtime';
import classNames from 'classnames';
import { PureComponent } from 'react';
import ReactSelect, { components } from 'react-select';
import ReactAsyncSelect from 'react-select/async';
import Creatable from 'react-select/creatable';
import { ThemeContext } from '@grafana/data';
import { ScrollContainer } from '../../../ScrollContainer/ScrollContainer.js';
import { SingleValue } from '../../../Select/SingleValue.js';
import resetSelectStyles from '../../../Select/resetSelectStyles.js';
import { Tooltip } from '../../../Tooltip/Tooltip.js';
import { IndicatorsContainer } from './IndicatorsContainer.js';
import { NoOptionsMessage } from './NoOptionsMessage.js';
import { SelectOption } from './SelectOption.js';
import { SelectOptionGroup } from './SelectOptionGroup.js';

const MenuList = (props) => {
  return /* @__PURE__ */ jsx(components.MenuList, { ...props, children: /* @__PURE__ */ jsx(ScrollContainer, { showScrollIndicators: true, overflowX: "hidden", maxHeight: "inherit", children: props.children }) });
};
const _Select = class _Select extends PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect;
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable;
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = { ..._Select.defaultProps.components, ...components2 };
    return /* @__PURE__ */ jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsx(
        SelectComponent,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel,
          ...creatableOptions
        }
      );
    } });
  }
};
_Select.contextType = ThemeContext;
_Select.defaultProps = {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer,
    MenuList,
    Group: SelectOptionGroup
  }
};
let Select = _Select;
class AsyncSelect extends PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ jsx(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen, children: (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ jsx(
        ReactAsyncSelect,
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    } });
  }
}
AsyncSelect.contextType = ThemeContext;
AsyncSelect.defaultProps = {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
};
class WrapInTooltip extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      isOpenInternal: false
    };
    this.onOpenMenu = () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    };
    this.onCloseMenu = () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    };
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ jsx(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom", children: /* @__PURE__ */ jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) }) });
    } else {
      return /* @__PURE__ */ jsx("div", { children: children(this.onOpenMenu, this.onCloseMenu) });
    }
  }
}

export { AsyncSelect, MenuList, Select, WrapInTooltip, Select as default };
//# sourceMappingURL=Select.js.map
