import { jsx, jsxs } from 'react/jsx-runtime';
import { PureComponent } from 'react';
import { faro } from '@grafana/faro-web-sdk';
import { Alert } from '../Alert/Alert.js';
import { ErrorWithStack } from './ErrorWithStack.js';

class ErrorBoundary extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      error: null,
      errorInfo: null
    };
  }
  componentDidCatch(error, errorInfo) {
    var _a, _b;
    (_b = (_a = faro) == null ? void 0 : _a.api) == null ? void 0 : _b.pushError(error);
    this.setState({ error, errorInfo });
    if (this.props.onError) {
      this.props.onError(error);
    }
  }
  componentDidUpdate(prevProps) {
    const { dependencies, onRecover } = this.props;
    if (this.state.error) {
      if (dependencies && prevProps.dependencies) {
        for (let i = 0; i < dependencies.length; i++) {
          if (dependencies[i] !== prevProps.dependencies[i]) {
            this.setState({ error: null, errorInfo: null });
            if (onRecover) {
              onRecover();
            }
            break;
          }
        }
      }
    }
  }
  render() {
    const { children } = this.props;
    const { error, errorInfo } = this.state;
    return children({
      error,
      errorInfo
    });
  }
}
class ErrorBoundaryAlert extends PureComponent {
  render() {
    const { title, children, style, dependencies } = this.props;
    return /* @__PURE__ */ jsx(ErrorBoundary, { dependencies, children: ({ error, errorInfo }) => {
      if (!errorInfo) {
        return children;
      }
      if (style === "alertbox") {
        return /* @__PURE__ */ jsx(Alert, { title: title || "", children: /* @__PURE__ */ jsxs("details", { style: { whiteSpace: "pre-wrap" }, children: [
          error && error.toString(),
          /* @__PURE__ */ jsx("br", {}),
          errorInfo.componentStack
        ] }) });
      }
      return /* @__PURE__ */ jsx(ErrorWithStack, { title: title || "", error, errorInfo });
    } });
  }
}
ErrorBoundaryAlert.defaultProps = {
  title: "An unexpected error happened",
  style: "alertbox"
};
function withErrorBoundary(Component, errorBoundaryProps = {}) {
  const comp = (props) => /* @__PURE__ */ jsx(ErrorBoundaryAlert, { ...errorBoundaryProps, children: /* @__PURE__ */ jsx(Component, { ...props }) });
  comp.displayName = "WithErrorBoundary";
  return comp;
}

export { ErrorBoundary, ErrorBoundaryAlert, withErrorBoundary };
//# sourceMappingURL=ErrorBoundary.js.map
