const getCopiedText = (textBlocks, startOffset, endOffset) => {
  if (!textBlocks.length) {
    return void 0;
  }
  const excludingLastLineLength = textBlocks.slice(0, -1).join("").length + textBlocks.length - 1;
  return textBlocks.join("\n").slice(startOffset, excludingLastLineLength + endOffset);
};
const removeBom = (str) => {
  return str == null ? void 0 : str.replace(/[\uFEFF]/g, "");
};
function ClipboardPlugin() {
  const clipboardPlugin = {
    onCopy(event, editor, next) {
      event.preventDefault();
      const { document, selection } = editor.value;
      const {
        start: { offset: startOffset },
        end: { offset: endOffset }
      } = selection;
      const selectedBlocks = document.getLeafBlocksAtRange(selection).toArray().map((block) => block.text);
      const copiedText = removeBom(getCopiedText(selectedBlocks, startOffset, endOffset));
      if (copiedText && event.clipboardData) {
        event.clipboardData.setData("Text", copiedText);
      }
      return true;
    },
    onPaste(event, editor, next) {
      event.preventDefault();
      if (event.clipboardData) {
        const pastedValue = removeBom(event.clipboardData.getData("Text"));
        const lines = pastedValue == null ? void 0 : pastedValue.split("\n");
        if (lines && lines.length) {
          editor.insertText(lines[0]);
          for (const line of lines.slice(1)) {
            editor.splitBlock().insertText(line);
          }
        }
      }
      return true;
    }
  };
  return {
    ...clipboardPlugin,
    onCut(event, editor, next) {
      clipboardPlugin.onCopy(event, editor, next);
      editor.deleteAtRange(editor.value.selection);
      return true;
    }
  };
}

export { ClipboardPlugin };
//# sourceMappingURL=clipboard.js.map
