import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { InlineSwitch } from '../Switch/Switch.js';
import { InlineField } from '../Forms/InlineField.js';

function SecureSocksProxySettings({
  options,
  onOptionsChange
}) {
  var _a;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h3", { className: "page-heading", children: "Secure Socks Proxy" }),
    /* @__PURE__ */ jsx("div", { className: "gf-form-group", children: /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
      InlineField,
      {
        labelWidth: 26,
        label: "Enabled",
        tooltip: "Connect to this datasource via the secure socks proxy.",
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            value: (_a = options.jsonData.enableSecureSocksProxy) != null ? _a : false,
            onChange: (event) => onOptionsChange({
              ...options,
              jsonData: { ...options.jsonData, enableSecureSocksProxy: event.currentTarget.checked }
            })
          }
        )
      }
    ) }) }) })
  ] });
}

export { SecureSocksProxySettings };
//# sourceMappingURL=SecureSocksProxySettings.js.map
