---
aliases:
  - ../../../enterprise/access-control/fine-grained-access-control-references/
  - ../../../enterprise/access-control/rbac-fixed-basic-role-definitions/
description: This topic includes a table that lists permission associated with Grafana
  fixed and basic roles.
labels:
  products:
    - cloud
    - enterprise
menuTitle: RBAC role definitions
title: Grafana RBAC role definitions
weight: 70
refs:
  rbac-basic-roles:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/#basic-roles
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/#basic-roles
  rbac-terraform-provisioning:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/rbac-terraform-provisioning/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/rbac-terraform-provisioning/
  rbac-manage-rbac-roles:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/manage-rbac-roles/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/manage-rbac-roles/
  plan-rbac-rollout-strategy-create-a-custom-role-to-access-alerts-in-a-folder:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/access-control/plan-rbac-rollout-strategy/#create-a-custom-role-to-access-alerts-in-a-folder
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/account-management/authentication-and-permissions/access-control/plan-rbac-rollout-strategy/#create-a-custom-role-to-access-alerts-in-a-folder
  oncall:
    - pattern: /docs/grafana/
      destination: /docs/oncall/<GRAFANA_VERSION>/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/oncall/
  available-grafana-oncall-rbac-roles--granted-actions:
    - pattern: /docs/grafana/
      destination: /docs/oncall/<GRAFANA_VERSION>/user-and-team-management/#available-grafana-oncall-rbac-roles--granted-actions
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/oncall/user-and-team-management/#available-grafana-oncall-rbac-roles--granted-actions
---

# RBAC role definitions

{{% admonition type="note" %}}
Available in [Grafana Enterprise](/docs/grafana/<GRAFANA_VERSION>/introduction/grafana-enterprise/) and [Grafana Cloud](/docs/grafana-cloud).
{{% /admonition %}}

The following tables list permissions associated with basic and fixed roles.

## Basic role assignments

| Basic role    | UID                   | Associated fixed roles                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Description                                                                                                                                              |
| ------------- | --------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Grafana Admin | `basic_grafana_admin` | `fixed:roles:reader`<br>`fixed:roles:writer`<br>`fixed:users:reader`<br>`fixed:users:writer`<br>`fixed:org.users:reader`<br>`fixed:org.users:writer`<br>`fixed:ldap:reader`<br>`fixed:ldap:writer`<br>`fixed:stats:reader`<br>`fixed:settings:reader`<br>`fixed:settings:writer`<br>`fixed:provisioning:writer`<br>`fixed:organization:reader`<br>`fixed:organization:maintainer`<br>`fixed:licensing:reader`<br>`fixed:licensing:writer`<br>`fixed:datasources.caching:reader`<br>`fixed:datasources.caching:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:plugins:maintainer`<br>`fixed:authentication.config:writer`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:writer`<br>`fixed:library.panels:general.writer`                                                                                                                                                                                                                                                                                                         | Default [Grafana server administrator](/docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/#grafana-server-administrators) assignments. |
| Admin         | `basic_admin`         | `fixed:reports:reader`<br>`fixed:reports:writer`<br>`fixed:datasources:reader`<br>`fixed:datasources:writer`<br>`fixed:organization:writer`<br>`fixed:datasources.permissions:reader`<br>`fixed:datasources.permissions:writer`<br>`fixed:teams:writer`<br>`fixed:dashboards:reader`<br>`fixed:dashboards:writer`<br>`fixed:dashboards.permissions:reader`<br>`fixed:dashboards.permissions:writer`<br>`fixed:dashboards.public:writer`<br>`fixed:folders:reader`<br>`fixed:folders:writer`<br>`fixed:folders.permissions:reader`<br>`fixed:folders.permissions:writer`<br>`fixed:alerting:writer`<br>`fixed:apikeys:reader`<br>`fixed:apikeys:writer`<br>`fixed:alerting.provisioning.secrets:reader`<br>`fixed:alerting.provisioning:writer`<br>`fixed:datasources.caching:reader`<br>`fixed:datasources.caching:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:plugins:writer`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:writer`<br>`fixed:library.panels:general.writer`<br>`fixed:alerting.provisioning.status:writer` | Default [Grafana organization administrator](ref:rbac-basic-roles) assignments.                                                                          |
| Editor        | `basic_editor`        | `fixed:datasources:explorer`<br>`fixed:dashboards:creator`<br>`fixed:folders:creator`<br>`fixed:annotations:writer`<br>`fixed:teams:creator` if the `editors_can_admin` configuration flag is enabled<br>`fixed:alerting:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:general.writer`<br>`fixed:alerting.provisioning.status:writer`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Default [Editor](ref:rbac-basic-roles) assignments.                                                                                                      |
| Viewer        | `basic_viewer`        | `fixed:datasources.id:reader`<br>`fixed:organization:reader`<br>`fixed:annotations:reader`<br>`fixed:annotations.dashboard:writer`<br>`fixed:alerting:reader`<br>`fixed:plugins.app:reader`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:datasources:explorer` if the `viewers_can_edit` configuration flag is enabled                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Default [Viewer](ref:rbac-basic-roles) assignments.                                                                                                      |
| No Basic Role | n/a                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Default [No Basic Role](ref:rbac-basic-roles)                                                                                                            |

## Fixed role definitions

The following table has the existing built-in fixed role definitions. Other fixed roles might be added by plugins installed in Grafana.
The UUID presented here can be used as an identifier for [Terraform provisioning](ref:rbac-terraform-provisioning).

{{< admonition type="caution" >}}
These UUIDs won't be available if your instance was created before Grafana v10.2.0.

To learn how to use the roles API to determine the role UUIDs, refer to [Manage RBAC roles](ref:rbac-manage-rbac-roles).
{{< /admonition >}}

| Fixed role                                   | UUID                                | Permissions                                                                                                                                                                                                                                                                 | Description                                                                                                                                                                                                                                                                           |
| -------------------------------------------- | ----------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `fixed:alerting:reader`                      | `fixed_O2oP1_uBFozI2i93klAkcvEWR30` | All permissions from `fixed:alerting.rules:reader` <br>`fixed:alerting.instances:reader`<br>`fixed:alerting.notifications:reader`                                                                                                                                           | Read-only permissions for all Grafana, Mimir, Loki and Alertmanager alert rules\*, alerts, contact points, and notification policies.[\*](#alerting-roles)                                                                                                                            |
| `fixed:alerting:writer`                      | `fixed_-PAZgSJsDlRD8NUg-PFSeH_BkJY` | All permissions from `fixed:alerting.rules:writer` <br>`fixed:alerting.instances:writer`<br>`fixed:alerting.notifications:writer`                                                                                                                                           | Create, update, and delete Grafana, Mimir, Loki and Alertmanager alert rules\*, silences, contact points, templates, mute timings, and notification policies.[\*](#alerting-roles)                                                                                                    |
| `fixed:alerting.instances:reader`            | `fixed_ut5fVS-Ulh_ejFoskFhJT_rYg0Y` | `alert.instances:read` for organization scope <br> `alert.instances.external:read` for scope `datasources:*`                                                                                                                                                                | Read all alerts and silences in the organization produced by Grafana Alerts and Mimir and Loki alerts and silences.[\*](#alerting-roles)                                                                                                                                              |
| `fixed:alerting.instances:writer`            | `fixed_pKOBJE346uyqMLdgWbk1NsQfEl0` | All permissions from `fixed:alerting.instances:reader` and<br> `alert.instances:create`<br>`alert.instances:write` for organization scope <br> `alert.instances.external:write` for scope `datasources:*`                                                                   | Create, update and expire all silences in the organization produced by Grafana, Mimir, and Loki.[\*](#alerting-roles)                                                                                                                                                                 |
| `fixed:alerting.notifications:reader`        | `fixed_hmBn0lX5h1RZXB9Vaot420EEdA0` | `alert.notifications:read` for organization scope<br>`alert.notifications.external:read` for scope `datasources:*`                                                                                                                                                          | Read all Grafana and Alertmanager contact points, templates, and notification policies.[\*](#alerting-roles)                                                                                                                                                                          |
| `fixed:alerting.notifications:writer`        | `fixed_XplK6HPNxf9AP5IGTdB5Iun4tJc` | All permissions from `fixed:alerting.notifications:reader` and<br>`alert.notifications:write`for organization scope<br>`alert.notifications.external:read` for scope `datasources:*`                                                                                        | Create, update, and delete contact points, templates, mute timings and notification policies for Grafana and external Alertmanager.[\*](#alerting-roles)                                                                                                                              |
| `fixed:alerting.provisioning:writer`         | `fixed_y7pFjdEkxpx5ETdcxPvp0AgRuUo` | `alert.provisioning:read` and `alert.provisioning:write`                                                                                                                                                                                                                    | Create, update and delete Grafana alert rules, notification policies, contact points, templates, etc via provisioning API. [\*](#alerting-roles)                                                                                                                                      |
| `fixed:alerting.provisioning.secrets:reader` | `fixed_9fmzXXZZG-Od0Amy2ofEG8Uk--c` | `alert.provisioning:read` and `alert.provisioning.secrets:read`                                                                                                                                                                                                             | Read-only permissions for Provisioning API and let export resources with decrypted secrets [\*](#alerting-roles)                                                                                                                                                                      |
| `fixed:alerting.provisioning.status:writer`  | `fixed_eAxlzfkTuobvKEgXHveFMBZrOj8` | `alert.provisioning.provenance:write`                                                                                                                                                                                                                                       | Set provenance status to alert rules, notification policies, contact points, etc. Should be used together with regular writer roles. [\*](#alerting-roles)                                                                                                                            |
| `fixed:alerting.rules:reader`                | `fixed_fRGKL_vAqUsmUWq5EYKnOha9DcA` | `alert.rule:read`, `alert.silences:read` for scope `folders:*` <br> `alert.rules.external:read` for scope `datasources:*` <br> `alert.notifications.time-intervals:read` <br> `alert.notifications.receivers:list`                                                          | Read all\* Grafana, Mimir, and Loki alert rules.[\*](#alerting-roles) and read rule-specific silences                                                                                                                                                                                 |
| `fixed:alerting.rules:writer`                | `fixed_YJJGwAalUwDZPrXSyFH8GfYBXAc` | All permissions from `fixed:alerting.rules:reader` and <br> `alert.rule:create` <br> `alert.rule:write` <br> `alert.rule:delete` <br> `alert.silences:create` <br> `alert.silences:write` for scope `folders:*` <br> `alert.rules.external:write` for scope `datasources:*` | Create, update, and delete all\* Grafana, Mimir, and Loki alert rules.[\*](#alerting-roles) and manage rule-specific silences                                                                                                                                                         |
| `fixed:annotations:reader`                   | `fixed_hpZnoizrfAJsrceNcNQqWYV-xNU` | `annotations:read` for scopes `annotations:type:*`                                                                                                                                                                                                                          | Read all annotations and annotation tags.                                                                                                                                                                                                                                             |
| `fixed:annotations:writer`                   | `fixed_ZVW-Aa9Tzle6J4s2aUFcq1StKWE` | All permissions from `fixed:annotations:reader` <br>`annotations:write` <br>`annotations.create`<br> `annotations:delete` for scope `annotations:type:*`                                                                                                                    | Read, create, update and delete all annotations and annotation tags.                                                                                                                                                                                                                  |
| `fixed:annotations.dashboard:writer`         | `fixed_8A775xenXeKaJk4Cr7bchP9yXOA` | `annotations:write` <br>`annotations.create`<br> `annotations:delete` for scope `annotations:type:dashboard`                                                                                                                                                                | Create, update and delete dashboard annotations and annotation tags.                                                                                                                                                                                                                  |
| `fixed:apikeys:reader`                       | `fixed_kYZ7UEkwEvGmCCjTrq07cFAVFws` | `apikeys:read` for scope `apikeys:*`                                                                                                                                                                                                                                        | Read all api keys.                                                                                                                                                                                                                                                                    |
| `fixed:apikeys:writer`                       | `fixed_anTrcpRkm21NBO1Q2CsX8y0fiCQ` | All permissions from `fixed:apikeys:reader` and <br> `apikeys:create` <br> `apikeys:delete` for scope `apikeys:*`                                                                                                                                                           | Read, create, delete all api keys.                                                                                                                                                                                                                                                    |
| `fixed:authentication.config:writer`         | `fixed_0rYhZ2Qnzs8AdB1nX7gexk3fHDw` | `settings:read` for scope `settings:auth.saml:*` <br> `settings:write` for scope `settings:auth.saml:*`                                                                                                                                                                     | Read and update authentication and SAML settings.                                                                                                                                                                                                                                     |
| `fixed:dashboards:creator`                   | `fixed_ZorKUcEPCM01A1fPakEzGBUyU64` | `dashboards:create`<br>`folders:read`                                                                                                                                                                                                                                       | Create dashboards.                                                                                                                                                                                                                                                                    |
| `fixed:dashboards:reader`                    | `fixed_Sgr67JTOhjQGFlzYRahOe45TdWM` | `dashboards:read`                                                                                                                                                                                                                                                           | Read all dashboards.                                                                                                                                                                                                                                                                  |
| `fixed:dashboards:writer`                    | `fixed_OK2YOQGIoI1G031hVzJB6rAJQAs` | All permissions from `fixed:dashboards:reader` and <br>`dashboards:write`<br>`dashboards:edit`<br>`dashboards:delete`<br>`dashboards:create`<br>`dashboards.permissions:read`<br>`dashboards.permissions:write`                                                             | Read, create, update, and delete all dashboards.                                                                                                                                                                                                                                      |
| `fixed:dashboards.insights:reader`           | `fixed_JlBJ2_gizP8zhgaeGE2rjyZe2Rs` | `dashboards.insights:read`                                                                                                                                                                                                                                                  | Read dashboard insights data and see presence indicators.                                                                                                                                                                                                                             |
| `fixed:dashboards.permissions:reader`        | `fixed_f17oxuXW_58LL8mYJsm4T_mCeIw` | `dashboards.permissions:read`                                                                                                                                                                                                                                               | Read all dashboard permissions.                                                                                                                                                                                                                                                       |
| `fixed:dashboards.permissions:writer`        | `fixed_CcznxhWX_Yqn8uWMXMQ-b5iFW9k` | All permissions from `fixed:dashboards.permissions:reader` and <br>`dashboards.permissions:write`                                                                                                                                                                           | Read and update all dashboard permissions.                                                                                                                                                                                                                                            |
| `fixed:dashboards.public:writer`             | `fixed_f_GHHRBciaqESXfGz2oCcooqHxs` | `dashboards.public:write`                                                                                                                                                                                                                                                   | Create, update, delete or pause a public dashboard.                                                                                                                                                                                                                                   |
| `fixed:datasources:creator`                  | `fixed_XX8jHREgUt-wo1A-rPXIiFlX6Zw` | `datasources:create`                                                                                                                                                                                                                                                        | Create data sources.                                                                                                                                                                                                                                                                  |
| `fixed:datasources:explorer`                 | `fixed_qDzW9mzx9yM91T5Bi8dHUM2muTw` | `datasources:explore`                                                                                                                                                                                                                                                       | Enable the Explore feature. Data source permissions still apply, you can only query data sources for which you have query permissions.                                                                                                                                                |
| `fixed:datasources:reader`                   | `fixed_C2x8IxkiBc1KZVjyYH775T9jNMQ` | `datasources:read`<br>`datasources:query`                                                                                                                                                                                                                                   | Read and query data sources.                                                                                                                                                                                                                                                          |
| `fixed:datasources:writer`                   | `fixed_q8HXq8kjjA5IlHHgBJlKlUyaNik` | All permissions from `fixed:datasources:reader` and <br>`datasources:create`<br>`datasources:write`<br>`datasources:delete`                                                                                                                                                 | Read, query, create, delete, or update a data source.                                                                                                                                                                                                                                 |
| `fixed:datasources.caching:reader`           | `fixed_D2ddpGxJYlw0mbsTS1ek9fj0kj4` | `datasources.caching:read`                                                                                                                                                                                                                                                  | Read data source query caching settings.                                                                                                                                                                                                                                              |
| `fixed:datasources.caching:writer`           | `fixed_JtFjHr7jd7hSqUYcktKvRvIOGRE` | `datasources.caching:read`<br>`datasources.caching:write`                                                                                                                                                                                                                   | Enable, disable, or update query caching settings.                                                                                                                                                                                                                                    |
| `fixed:datasources.id:reader`                | `fixed_entg--fHmDqWY2-69N0ocawK0Os` | `datasources.id:read`                                                                                                                                                                                                                                                       | Read the ID of a data source based on its name.                                                                                                                                                                                                                                       |
| `fixed:datasources.insights:reader`          | `fixed_EBZ3NwlfecNPp2p0XcZRC1nfEYk` | `datasources.insights:read`                                                                                                                                                                                                                                                 | Read data source insights data.                                                                                                                                                                                                                                                       |
| `fixed:datasources.permissions:reader`       | `fixed_ErYA-cTN3yn4h4GxaVPcawRhiOY` | `datasources.permissions:read`                                                                                                                                                                                                                                              | Read data source permissions.                                                                                                                                                                                                                                                         |
| `fixed:datasources.permissions:writer`       | `fixed_aiQh9YDfLOKjQhYasF9_SFUjQiw` | All permissions from `fixed:datasources.permissions:reader` and <br>`datasources.permissions:write`                                                                                                                                                                         | Create, read, or delete permissions of a data source.                                                                                                                                                                                                                                 |
| `fixed:folders:creator`                      | `fixed_gGLRbZGAGB6n9uECqSh_W382RlQ` | `folders:create`                                                                                                                                                                                                                                                            | Create folders in the root level.                                                                                                                                                                                                                                                     |
| `fixed:folders:reader`                       | `fixed_yeW-5QPeo-i5PZUIUXMlAA97GnQ` | `folders:read`<br>`dashboards:read`                                                                                                                                                                                                                                         | Read all folders and dashboards.                                                                                                                                                                                                                                                      |
| `fixed:folders:writer`                       | `fixed_wJXLoTzgE7jVuz90dryYoiogL0o` | All permissions from `fixed:dashboards:writer` and <br>`folders:read`<br>`folders:write`<br>`folders:create`<br>`folders:delete`<br>`folders.permissions:read`<br>`folders.permissions:write`                                                                               | Read, update, and delete all folders and dashboards. Create folders and subfolders.                                                                                                                                                                                                   |
| `fixed:folders.permissions:reader`           | `fixed_E06l4cx0JFm47EeLBE4nmv3pnSo` | `folders.permissions:read`                                                                                                                                                                                                                                                  | Read all folder permissions.                                                                                                                                                                                                                                                          |
| `fixed:folders.permissions:writer`           | `fixed_3GAgpQ_hWG8o7-lwNb86_VB37eI` | All permissions from `fixed:folders.permissions:reader` and <br>`folders.permissions:write`                                                                                                                                                                                 | Read and update all folder permissions.                                                                                                                                                                                                                                               |
| `fixed:ldap:reader`                          | `fixed_lMcOPwSkxKY-qCK8NMJc5k6izLE` | `ldap.user:read`<br>`ldap.status:read`                                                                                                                                                                                                                                      | Read the LDAP configuration and LDAP status information.                                                                                                                                                                                                                              |
| `fixed:ldap:writer`                          | `fixed_p6AvnU4GCQyIh7-hbwI-bk3GYnU` | All permissions from `fixed:ldap:reader` and <br>`ldap.user:sync`<br>`ldap.config:reload`                                                                                                                                                                                   | Read and update the LDAP configuration, and read LDAP status information.                                                                                                                                                                                                             |
| `fixed:library.panels:creator`               | `fixed_6eX6ItfegCIY5zLmPqTDW8ZV7KY` | `library.panels:create`<br>`folders:read`                                                                                                                                                                                                                                   | Create library panel at the root level.                                                                                                                                                                                                                                               |
| `fixed:library.panels:general.reader`        | `fixed_ct0DghiBWR_2BiQm3EvNPDVmpio` | `library.panels:read`                                                                                                                                                                                                                                                       | Read all library panels at the root level.                                                                                                                                                                                                                                            |
| `fixed:library.panels:general.writer`        | `fixed_DgprkmqfN_1EhZ2v1_d1fYG8LzI` | All permissions from `fixed:library.panels:general.reader` plus<br>`library.panels:create`<br>`library.panels:delete`<br>`library.panels:write`                                                                                                                             | Create, read, write or delete all library panels and their permissions at the root level.                                                                                                                                                                                             |
| `fixed:library.panels:reader`                | `fixed_tvTr9CnZ6La5vvUO_U_X1LPnhUs` | `library.panels:read`                                                                                                                                                                                                                                                       | Read all library panels.                                                                                                                                                                                                                                                              |
| `fixed:library.panels:writer`                | `fixed_JTljAr21LWLTXCkgfBC4H0lhBC8` | All permissions from `fixed:library.panels:reader` plus<br>`library.panels:create`<br>`library.panels:delete`<br>`library.panels:write`                                                                                                                                     | Create, read, write or delete all library panels and their permissions.                                                                                                                                                                                                               |
| `fixed:licensing:reader`                     | `fixed_OADpuXvNEylO2Kelu3GIuBXEAYE` | `licensing:read`<br>`licensing.reports:read`                                                                                                                                                                                                                                | Read licensing information and licensing reports.                                                                                                                                                                                                                                     |
| `fixed:licensing:writer`                     | `fixed_gzbz3rJpQMdaKHt-E4q0PVaKMoE` | All permissions from `fixed:licensing:viewer` and <br>`licensing:write`<br>`licensing:delete`                                                                                                                                                                               | Read licensing information and licensing reports, update and delete the license token.                                                                                                                                                                                                |
| `fixed:org.users:reader`                     | `fixed_oCqNwlVHLOpw7-jAlwp4HzYqwGY` | `org.users:read`                                                                                                                                                                                                                                                            | Read users within a single organization.                                                                                                                                                                                                                                              |
| `fixed:org.users:writer`                     | `fixed_VERj5nayasjgf_Yh0sWqqCkxWlw` | All permissions from `fixed:org.users:reader` and <br>`org.users:add`<br>`org.users:remove`<br>`org.users:write`                                                                                                                                                            | Within a single organization, add a user, invite a new user, read information about a user and their role, remove a user from that organization, or change the role of a user.                                                                                                        |
| `fixed:organization:maintainer`              | `fixed_CMm-uuBaPUBf4r8XG3jIvxo55bg` | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs:create`<br>`orgs:delete`<br>`orgs.quotas:write`                                                                                                                                             | Create, read, write, or delete an organization. Read or write its quotas. This role needs to be assigned globally.                                                                                                                                                                    |
| `fixed:organization:reader`                  | `fixed_0SZPJlTHdNEe8zO91zv7Zwiwa2w` | `orgs:read`<br>`orgs.quotas:read`                                                                                                                                                                                                                                           | Read an organization and its quotas.                                                                                                                                                                                                                                                  |
| `fixed:organization:writer`                  | `fixed_Y4jGqDd8w1yCrPwlik8z5Iu8-3M` | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs.preferences:read`<br>`orgs.preferences:write`                                                                                                                                               | Read an organization, its quotas, or its preferences. Update organization properties, or its preferences.                                                                                                                                                                             |
| `fixed:plugins:maintainer`                   | `fixed_yEOKidBcWgbm74x-nTa3lW5lOyY` | `plugins:install`                                                                                                                                                                                                                                                           | Install and uninstall plugins. Needs to be assigned globally.                                                                                                                                                                                                                         |
| `fixed:plugins:writer`                       | `fixed_MRYpGk7kpNNwt2VoVOXFiPnQziE` | `plugins:write`                                                                                                                                                                                                                                                             | Enable and disable plugins and edit plugins' settings.                                                                                                                                                                                                                                |
| `fixed:plugins.app:reader`                   | `fixed_AcZRiNYx7NueYkUqzw1o2OGGUAA` | `plugins.app:access`                                                                                                                                                                                                                                                        | Access application plugins (still enforcing the organization role).                                                                                                                                                                                                                   |
| `fixed:provisioning:writer`                  | `fixed_bgk1FCyR6OEDwhgirZlQgu5LlCA` | `provisioning:reload`                                                                                                                                                                                                                                                       | Reload provisioning.                                                                                                                                                                                                                                                                  |
| `fixed:reports:reader`                       | `fixed_72_8LU_0ukfm6BdblOw8Z9q-GQ8` | `reports:read`<br>`reports:send`<br>`reports.settings:read`                                                                                                                                                                                                                 | Read all reports and shared report settings.                                                                                                                                                                                                                                          |
| `fixed:reports:writer`                       | `fixed_jBW3_7g1EWOjGVBYeVRwtFxhUNw` | All permissions from `fixed:reports:reader` and <br>`reports:create`<br>`reports:write`<br>`reports:delete`<br>`reports.settings:write`                                                                                                                                     | Create, read, update, or delete all reports and shared report settings.                                                                                                                                                                                                               |
| `fixed:roles:reader`                         | `fixed_GkfG-1NSwEGb4hpK3-E3qHyNltc` | `roles:read`<br>`teams.roles:read`<br>`users.roles:read`<br>`users.permissions:read`                                                                                                                                                                                        | Read all access control roles, roles and permissions assigned to users, teams.                                                                                                                                                                                                        |
| `fixed:roles:resetter`                       | `fixed_WgPpC3qJRmVpVTJavFNwfS5RuzQ` | `roles:write` with scope `permissions:type:escalate`                                                                                                                                                                                                                        | Reset basic roles to their default.                                                                                                                                                                                                                                                   |
| `fixed:roles:writer`                         | `fixed_W5aFaw8isAM27x_eWfElBhZ0iOc` | All permissions from `fixed:roles:reader` and <br>`roles:write`<br>`roles:delete`<br>`teams.roles:add`<br>`teams.roles:remove`<br>`users.roles:add`<br>`users.roles:remove`                                                                                                 | Create, read, update, or delete all roles, assign or unassign roles to users, teams.                                                                                                                                                                                                  |
| `fixed:serviceaccounts:creator`              | `fixed_Ikw60fckA0MyiiZ73BawSfOULy4` | `serviceaccounts:create`                                                                                                                                                                                                                                                    | Create Grafana service accounts.                                                                                                                                                                                                                                                      |
| `fixed:serviceaccounts:reader`               | `fixed_QFjJAZ88iawMLInYOxPA1DB1w6I` | `serviceaccounts:read`                                                                                                                                                                                                                                                      | Read Grafana service accounts.                                                                                                                                                                                                                                                        |
| `fixed:serviceaccounts:writer`               | `fixed_iBvUNUEZBZ7PUW0vdkN5iojc2sk` | `serviceaccounts:read`<br>`serviceaccounts:create`<br>`serviceaccounts:write`<br>`serviceaccounts:delete`<br>`serviceaccounts.permissions:read`<br>`serviceaccounts.permissions:write`                                                                                      | Create, update, read and delete all Grafana service accounts and manage service account permissions.                                                                                                                                                                                  |
| `fixed:settings:reader`                      | `fixed_0LaUt1x6PP8hsZzEBhqPQZFUd8Q` | `settings:read`                                                                                                                                                                                                                                                             | Read Grafana instance settings.                                                                                                                                                                                                                                                       |
| `fixed:settings:writer`                      | `fixed_joIHDgMrGg790hMhUufVzcU4j44` | All permissions from `fixed:settings:reader` and<br>`settings:write`                                                                                                                                                                                                        | Read and update Grafana instance settings.                                                                                                                                                                                                                                            |
| `fixed:stats:reader`                         | `fixed_OnRCXxZVINWpcKvTF5A1gecJ7pA` | `server.stats:read`                                                                                                                                                                                                                                                         | Read Grafana instance statistics.                                                                                                                                                                                                                                                     |
| `fixed:teams:creator`                        | `fixed_nzVQoNSDSn0fg1MDgO6XnZX2RZI` | `teams:create`<br>`org.users:read`                                                                                                                                                                                                                                          | Create a team and list organization users (required to manage the created team).                                                                                                                                                                                                      |
| `fixed:teams:reader`                         | `fixed_3SNL15gkRtJ7XeEKpMVJyQjYbjg` | `teams:read`                                                                                                                                                                                                                                                                | List all teams.                                                                                                                                                                                                                                                                       |
| `fixed:teams:writer`                         | `fixed_xw1T0579h620MOYi4L96GUs7fZY` | `teams:create`<br>`teams:delete`<br>`teams:read`<br>`teams:write`<br>`teams.permissions:read`<br>`teams.permissions:write`                                                                                                                                                  | Create, read, update and delete teams and manage team memberships.                                                                                                                                                                                                                    |
| `fixed:users:reader`                         | `fixed_buZastUG3reWyQpPemcWjGqPAd0` | `users:read`<br>`users.quotas:read`<br>`users.authtoken:read`<br>`                                                                                                                                                                                                          | Read all users and their information, such as team memberships, authentication tokens, and quotas.                                                                                                                                                                                    |
| `fixed:users:writer`                         | `fixed_wjzgHHo_Ux25DJuELn_oiAdB_yM` | All permissions from `fixed:users:reader` and <br>`users:write`<br>`users:create`<br>`users:delete`<br>`users:enable`<br>`users:disable`<br>`users.password:write`<br>`users.permissions:write`<br>`users:logout`<br>`users.authtoken:write`<br>`users.quotas:write`        | Read and update all attributes and settings for all users in Grafana: update user information, read user information, create or enable or disable a user, make a user a Grafana administrator, sign out a user, update a user’s authentication token, or update quotas for all users. |

### Alerting roles

You can use predefined roles to manage user access to alert rules, alert instances, and alert notification settings and create custom roles to limit user access to alert rules in a folder.

Access to Grafana alert rules is an intersection of many permissions:

- Permission to read a folder. For example, the fixed role `fixed:folders:reader` includes the action `folders:read` and a folder scope `folders:id:`.
- Permission to query **all** data sources that a given alert rule uses. If a user cannot query a given data source, they cannot see any alert rules that query that data source.

There is only one exclusion at this moment. Role `fixed:alerting.provisioning:writer` does not require user to have any additional permissions and provides access to all aspects of the alerting configuration via special provisioning API.

For more information about the permissions required to access alert rules, refer to [Create a custom role to access alerts in a folder](ref:plan-rbac-rollout-strategy-create-a-custom-role-to-access-alerts-in-a-folder).

### Grafana OnCall roles (beta)

{{% admonition type="note" %}}
Available from Grafana 9.4 in early access.
{{% /admonition %}}

{{% admonition type="note" %}}
This feature is behind the `accessControlOnCall` feature toggle.
You can enable feature toggles through configuration file or environment variables. See configuration [docs](/docs/grafana/<GRAFANA_VERSION>/setup-grafana/configure-grafana/#feature_toggles) for details.
{{% /admonition %}}

If you are using [Grafana OnCall](ref:oncall), you can try out the integration between Grafana OnCall and RBAC.
For a detailed list of the available OnCall RBAC roles, refer to the table in [Available Grafana OnCall RBAC roles and granted actions](ref:available-grafana-oncall-rbac-roles--granted-actions).

The following table lists the default RBAC OnCall role assignments to the basic roles:

| Basic role    | Associated fixed roles              | Description                                                                                                                                              |
| ------------- | ----------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Grafana Admin | `plugins:grafana-oncall-app:admin`  | Default [Grafana server administrator](/docs/grafana/<GRAFANA_VERSION>/administration/roles-and-permissions/#grafana-server-administrators) assignments. |
| Admin         | `plugins:grafana-oncall-app:admin`  | Default [Grafana organization administrator](ref:rbac-basic-roles) assignments.                                                                          |
| Editor        | `plugins:grafana-oncall-app:editor` | Default [Editor](ref:rbac-basic-roles) assignments.                                                                                                      |
| Viewer        | `plugins:grafana-oncall-app:reader` | Default [Viewer](ref:rbac-basic-roles) assignments.                                                                                                      |
