import { jsx } from 'react/jsx-runtime';
import { forwardRef } from 'react';
import { Link as Link$1 } from 'react-router-dom-v5-compat';
import { locationUtil, textUtil } from '@grafana/data';

const Link = forwardRef(({ href, children, ...rest }, ref) => {
  const validUrl = locationUtil.stripBaseFromUrl(textUtil.sanitizeUrl(href != null ? href : ""));
  return /* @__PURE__ */ jsx(Link$1, { ref, to: validUrl, ...rest, children });
});
Link.displayName = "Link";

export { Link };
//# sourceMappingURL=Link.js.map
