---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about feature toggles, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L27 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to enable or disable features in Grafana. You can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation](../#feature_toggles). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

For more information about feature release stages, refer to [Release life cycle for Grafana Labs](https://grafana.com/docs/release-life-cycle/) and [Manage feature toggles](https://grafana.com/docs/grafana/<GRAFANA_VERSION>/administration/feature-toggles/#manage-feature-toggles).

## General availability feature toggles

Most [generally available](https://grafana.com/docs/release-life-cycle/#general-availability) features are enabled by default. You can disable these feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                    | Description                                                                                                                                                               | Enabled by default |
| -------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`            | Disable envelope encryption (emergency only)                                                                                                                              |                    |
| `publicDashboards`                     | [Deprecated] Public dashboards are now enabled by default; to disable them, use the configuration setting. This feature toggle will be removed in the next major version. | Yes                |
| `publicDashboardsScene`                | Enables public dashboard rendering using scenes                                                                                                                           | Yes                |
| `featureHighlights`                    | Highlight Grafana Enterprise features                                                                                                                                     |                    |
| `correlations`                         | Correlations page                                                                                                                                                         | Yes                |
| `autoMigrateXYChartPanel`              | Migrate old XYChart panel to new XYChart2 model                                                                                                                           | Yes                |
| `cloudWatchCrossAccountQuerying`       | Enables cross-account querying in CloudWatch datasources                                                                                                                  | Yes                |
| `accessControlOnCall`                  | Access control primitives for OnCall                                                                                                                                      | Yes                |
| `nestedFolders`                        | Enable folder nesting                                                                                                                                                     | Yes                |
| `logsContextDatasourceUi`              | Allow datasource to provide custom UI for context view                                                                                                                    | Yes                |
| `lokiQuerySplitting`                   | Split large interval queries into subqueries with smaller time intervals                                                                                                  | Yes                |
| `prometheusMetricEncyclopedia`         | Adds the metrics explorer component to the Prometheus query builder as an option in metric select                                                                         | Yes                |
| `influxdbBackendMigration`             | Query InfluxDB InfluxQL without the proxy                                                                                                                                 | Yes                |
| `lokiMetricDataplane`                  | Changes metric responses from Loki to be compliant with the dataplane specification.                                                                                      | Yes                |
| `dataplaneFrontendFallback`            | Support dataplane contract field name change for transformations and field name matchers where the name is different                                                      | Yes                |
| `recordedQueriesMulti`                 | Enables writing multiple items from a single query within Recorded Queries                                                                                                | Yes                |
| `logsExploreTableVisualisation`        | A table visualisation for logs in Explore                                                                                                                                 | Yes                |
| `transformationsRedesign`              | Enables the transformations redesign                                                                                                                                      | Yes                |
| `traceQLStreaming`                     | Enables response streaming of TraceQL queries of the Tempo data source                                                                                                    |                    |
| `awsAsyncQueryCaching`                 | Enable caching for async queries for Redshift and Athena. Requires that the datasource has caching and async query support enabled                                        | Yes                |
| `prometheusConfigOverhaulAuth`         | Update the Prometheus configuration page with the new auth component                                                                                                      | Yes                |
| `alertingNoDataErrorExecution`         | Changes how Alerting state manager handles execution of NoData/Error                                                                                                      | Yes                |
| `angularDeprecationUI`                 | Display Angular warnings in dashboards and panels                                                                                                                         | Yes                |
| `dashgpt`                              | Enable AI powered features in dashboards                                                                                                                                  | Yes                |
| `alertingInsights`                     | Show the new alerting insights landing page                                                                                                                               | Yes                |
| `panelMonitoring`                      | Enables panel monitoring through logs and measurements                                                                                                                    | Yes                |
| `formatString`                         | Enable format string transformer                                                                                                                                          | Yes                |
| `transformationsVariableSupport`       | Allows using variables in transformations                                                                                                                                 | Yes                |
| `kubernetesPlaylists`                  | Use the kubernetes API in the frontend for playlists, and route /api/playlist requests to k8s                                                                             | Yes                |
| `recoveryThreshold`                    | Enables feature recovery threshold (aka hysteresis) for threshold server-side expression                                                                                  | Yes                |
| `lokiStructuredMetadata`               | Enables the loki data source to request structured metadata from the Loki server                                                                                          | Yes                |
| `managedPluginsInstall`                | Install managed plugins directly from plugins catalog                                                                                                                     | Yes                |
| `addFieldFromCalculationStatFunctions` | Add cumulative and window functions to the add field from calculation transformation                                                                                      | Yes                |
| `annotationPermissionUpdate`           | Change the way annotation permissions work by scoping them to folders and dashboards.                                                                                     | Yes                |
| `dashboardSceneForViewers`             | Enables dashboard rendering using Scenes for viewer roles                                                                                                                 | Yes                |
| `dashboardSceneSolo`                   | Enables rendering dashboards using scenes for solo panels                                                                                                                 | Yes                |
| `dashboardScene`                       | Enables dashboard rendering using scenes for all roles                                                                                                                    | Yes                |
| `ssoSettingsApi`                       | Enables the SSO settings API and the OAuth configuration UIs in Grafana                                                                                                   | Yes                |
| `logsInfiniteScrolling`                | Enables infinite scrolling for the Logs panel in Explore and Dashboards                                                                                                   | Yes                |
| `exploreMetrics`                       | Enables the new Explore Metrics core app                                                                                                                                  | Yes                |
| `alertingSimplifiedRouting`            | Enables users to easily configure alert notifications by specifying a contact point directly when editing or creating an alert rule                                       | Yes                |
| `logRowsPopoverMenu`                   | Enable filtering menu displayed when text of a log line is selected                                                                                                       | Yes                |
| `lokiQueryHints`                       | Enables query hints for Loki                                                                                                                                              | Yes                |
| `alertingQueryOptimization`            | Optimizes eligible queries in order to reduce load on datasources                                                                                                         |                    |
| `promQLScope`                          | In-development feature that will allow injection of labels into prometheus queries.                                                                                       | Yes                |
| `groupToNestedTableTransformation`     | Enables the group to nested table transformation                                                                                                                          | Yes                |
| `tlsMemcached`                         | Use TLS-enabled memcached in the enterprise caching feature                                                                                                               | Yes                |
| `cloudWatchNewLabelParsing`            | Updates CloudWatch label parsing to be more accurate                                                                                                                      | Yes                |
| `newDashboardSharingComponent`         | Enables the new sharing drawer design                                                                                                                                     |                    |
| `notificationBanner`                   | Enables the notification banner UI and API                                                                                                                                | Yes                |
| `pluginProxyPreserveTrailingSlash`     | Preserve plugin proxy trailing slash.                                                                                                                                     |                    |
| `pinNavItems`                          | Enables pinning of nav items                                                                                                                                              | Yes                |
| `openSearchBackendFlowEnabled`         | Enables the backend query flow for Open Search datasource plugin                                                                                                          | Yes                |
| `cloudWatchRoundUpEndTime`             | Round up end time for metric queries to the next minute to avoid missing data                                                                                             | Yes                |

## Public preview feature toggles

[Public preview](https://grafana.com/docs/release-life-cycle/#public-preview) features are supported by our Support teams, but might be limited to enablement, configuration, and some troubleshooting.

| Feature toggle name                    | Description                                                                                                                                                                                  |
| -------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `panelTitleSearch`                     | Search for dashboards using panel title                                                                                                                                                      |
| `autoMigrateOldPanels`                 | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `autoMigrateGraphPanel`                | Migrate old graph panel to supported time series panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                    |
| `autoMigrateTablePanel`                | Migrate old table panel to supported table panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                          |
| `autoMigratePiechartPanel`             | Migrate old piechart panel to supported piechart panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                    |
| `autoMigrateWorldmapPanel`             | Migrate old worldmap panel to supported geomap panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                      |
| `autoMigrateStatPanel`                 | Migrate old stat panel to supported stat panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                            |
| `disableAngular`                       | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `grpcServer`                           | Run the GRPC server                                                                                                                                                                          |
| `alertingNoNormalState`                | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `renderAuthJWT`                        | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |
| `refactorVariablesTimeRange`           | Refactor time range variables flow to reduce number of API calls made when query variables are chained                                                                                       |
| `faroDatasourceSelector`               | Enable the data source selector within the Frontend Apps section of the Frontend Observability                                                                                               |
| `enableDatagridEditing`                | Enables the edit functionality in the datagrid panel                                                                                                                                         |
| `sqlDatasourceDatabaseSelection`       | Enables previous SQL data source dataset dropdown behavior                                                                                                                                   |
| `reportingRetries`                     | Enables rendering retries for the reporting feature                                                                                                                                          |
| `externalServiceAccounts`              | Automatic service account and token setup for plugins                                                                                                                                        |
| `cloudWatchBatchQueries`               | Runs CloudWatch metrics queries as separate batches                                                                                                                                          |
| `teamHttpHeaders`                      | Enables LBAC for datasources to apply LogQL filtering of logs to the client requests for users in teams                                                                                      |
| `pdfTables`                            | Enables generating table data as PDF in reporting                                                                                                                                            |
| `canvasPanelPanZoom`                   | Allow pan and zoom in canvas panel                                                                                                                                                           |
| `regressionTransformation`             | Enables regression analysis transformation                                                                                                                                                   |
| `onPremToCloudMigrations`              | Enable the Grafana Migration Assistant, which helps you easily migrate on-prem dashboards, folders, and data source configurations to your Grafana Cloud stack.                              |
| `newPDFRendering`                      | New implementation for the dashboard-to-PDF rendering                                                                                                                                        |
| `ssoSettingsSAML`                      | Use the new SSO Settings API to configure the SAML connector                                                                                                                                 |
| `accessActionSets`                     | Introduces action sets for resource permissions. Also ensures that all folder editors and admins can create subfolders without needing any additional permissions.                           |
| `azureMonitorPrometheusExemplars`      | Allows configuration of Azure Monitor as a data source that can provide Prometheus exemplars                                                                                                 |
| `ssoSettingsLDAP`                      | Use the new SSO Settings API to configure LDAP                                                                                                                                               |
| `cloudwatchMetricInsightsCrossAccount` | Enables cross account observability for Cloudwatch Metric Insights query builder                                                                                                             |
| `useSessionStorageForRedirection`      | Use session storage for handling the redirection after login                                                                                                                                 |

## Experimental feature toggles

[Experimental](https://grafana.com/docs/release-life-cycle/#experimental) features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Experimental features might be changed or removed without prior notice.

| Feature toggle name                           | Description                                                                                                                                                                                                                                                                       |
| --------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `live-service-web-worker`                     | This will use a webworker thread to processes events rather than the main thread                                                                                                                                                                                                  |
| `queryOverLive`                               | Use Grafana Live WebSocket to execute backend queries                                                                                                                                                                                                                             |
| `lokiExperimentalStreaming`                   | Support new streaming approach for loki (prototype, needs special loki build)                                                                                                                                                                                                     |
| `storage`                                     | Configurable storage for dashboards, datasources, and resources                                                                                                                                                                                                                   |
| `canvasPanelNesting`                          | Allow elements nesting                                                                                                                                                                                                                                                            |
| `vizActions`                                  | Allow actions in visualizations                                                                                                                                                                                                                                                   |
| `disableSecretsCompatibility`                 | Disable duplicated secret storage in legacy tables                                                                                                                                                                                                                                |
| `logRequestsInstrumentedAsUnknown`            | Logs the path for requests that are instrumented as unknown                                                                                                                                                                                                                       |
| `showDashboardValidationWarnings`             | Show warnings when dashboards do not validate against the schema                                                                                                                                                                                                                  |
| `mysqlAnsiQuotes`                             | Use double quotes to escape keyword in a MySQL query                                                                                                                                                                                                                              |
| `mysqlParseTime`                              | Ensure the parseTime flag is set for MySQL driver                                                                                                                                                                                                                                 |
| `alertingBacktesting`                         | Rule backtesting API for alerting                                                                                                                                                                                                                                                 |
| `editPanelCSVDragAndDrop`                     | Enables drag and drop for CSV and Excel files                                                                                                                                                                                                                                     |
| `lokiQuerySplittingConfig`                    | Give users the option to configure split durations for Loki queries                                                                                                                                                                                                               |
| `individualCookiePreferences`                 | Support overriding cookie preferences per user                                                                                                                                                                                                                                    |
| `influxqlStreamingParser`                     | Enable streaming JSON parser for InfluxDB datasource InfluxQL query language                                                                                                                                                                                                      |
| `lokiLogsDataplane`                           | Changes logs responses from Loki to be compliant with the dataplane specification.                                                                                                                                                                                                |
| `disableSSEDataplane`                         | Disables dataplane specific processing in server side expressions.                                                                                                                                                                                                                |
| `alertStateHistoryLokiSecondary`              | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations.                                                                                                                                                                      |
| `alertStateHistoryLokiPrimary`                | Enable a remote Loki instance as the primary source for state history reads.                                                                                                                                                                                                      |
| `alertStateHistoryLokiOnly`                   | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                                                                                                                                                                                        |
| `unifiedRequestLog`                           | Writes error logs to the request logger                                                                                                                                                                                                                                           |
| `extraThemes`                                 | Enables extra themes                                                                                                                                                                                                                                                              |
| `lokiPredefinedOperations`                    | Adds predefined query operations to Loki query editor                                                                                                                                                                                                                             |
| `pluginsFrontendSandbox`                      | Enables the plugins frontend sandbox                                                                                                                                                                                                                                              |
| `frontendSandboxMonitorOnly`                  | Enables monitor only in the plugin frontend sandbox (if enabled)                                                                                                                                                                                                                  |
| `pluginsDetailsRightPanel`                    | Enables right panel for the plugins details page                                                                                                                                                                                                                                  |
| `vizAndWidgetSplit`                           | Split panels between visualizations and widgets                                                                                                                                                                                                                                   |
| `awsDatasourcesTempCredentials`               | Support temporary security credentials in AWS plugins for Grafana Cloud customers                                                                                                                                                                                                 |
| `mlExpressions`                               | Enable support for Machine Learning in server-side expressions                                                                                                                                                                                                                    |
| `metricsSummary`                              | Enables metrics summary queries in the Tempo data source                                                                                                                                                                                                                          |
| `datasourceAPIServers`                        | Expose some datasources as apiservers.                                                                                                                                                                                                                                            |
| `permissionsFilterRemoveSubquery`             | Alternative permission filter implementation that does not use subqueries for fetching the dashboard folder                                                                                                                                                                       |
| `aiGeneratedDashboardChanges`                 | Enable AI powered features for dashboards to auto-summary changes when saving                                                                                                                                                                                                     |
| `sseGroupByDatasource`                        | Send query to the same datasource in a single request when using server side expressions. The `cloudWatchBatchQueries` feature toggle should be enabled if this used with CloudWatch.                                                                                             |
| `libraryPanelRBAC`                            | Enables RBAC support for library panels                                                                                                                                                                                                                                           |
| `wargamesTesting`                             | Placeholder feature flag for internal testing                                                                                                                                                                                                                                     |
| `externalCorePlugins`                         | Allow core plugins to be loaded as external                                                                                                                                                                                                                                       |
| `pluginsAPIMetrics`                           | Sends metrics of public grafana packages usage by plugins                                                                                                                                                                                                                         |
| `enableNativeHTTPHistogram`                   | Enables native HTTP Histograms                                                                                                                                                                                                                                                    |
| `disableClassicHTTPHistogram`                 | Disables classic HTTP Histogram (use with enableNativeHTTPHistogram)                                                                                                                                                                                                              |
| `kubernetesSnapshots`                         | Routes snapshot requests from /api to the /apis endpoint                                                                                                                                                                                                                          |
| `kubernetesDashboards`                        | Use the kubernetes API in the frontend for dashboards                                                                                                                                                                                                                             |
| `kubernetesFolders`                           | Use the kubernetes API in the frontend for folders, and route /api/folders requests to k8s                                                                                                                                                                                        |
| `grafanaAPIServerTestingWithExperimentalAPIs` | Facilitate integration testing of experimental APIs                                                                                                                                                                                                                               |
| `datasourceQueryTypes`                        | Show query type endpoints in datasource API servers (currently hardcoded for testdata, expressions, and prometheus)                                                                                                                                                               |
| `queryService`                                | Register /apis/query.grafana.app/ -- will eventually replace /api/ds/query                                                                                                                                                                                                        |
| `queryServiceRewrite`                         | Rewrite requests targeting /ds/query to the query service                                                                                                                                                                                                                         |
| `queryServiceFromUI`                          | Routes requests to the new query service                                                                                                                                                                                                                                          |
| `cachingOptimizeSerializationMemoryUsage`     | If enabled, the caching backend gradually serializes query responses for the cache, comparing against the configured `[caching]max_value_mb` value as it goes. This can can help prevent Grafana from running out of memory while attempting to cache very large query responses. |
| `prometheusPromQAIL`                          | Prometheus and AI/ML to assist users in creating a query                                                                                                                                                                                                                          |
| `prometheusCodeModeMetricNamesSearch`         | Enables search for metric names in Code Mode, to improve performance when working with an enormous number of metric names                                                                                                                                                         |
| `alertmanagerRemoteSecondary`                 | Enable Grafana to sync configuration and state with a remote Alertmanager.                                                                                                                                                                                                        |
| `alertmanagerRemotePrimary`                   | Enable Grafana to have a remote Alertmanager instance as the primary Alertmanager.                                                                                                                                                                                                |
| `alertmanagerRemoteOnly`                      | Disable the internal Alertmanager and only use the external one defined.                                                                                                                                                                                                          |
| `extractFieldsNameDeduplication`              | Make sure extracted field names are unique in the dataframe                                                                                                                                                                                                                       |
| `pluginsSkipHostEnvVars`                      | Disables passing host environment variable to plugin processes                                                                                                                                                                                                                    |
| `tableSharedCrosshair`                        | Enables shared crosshair in table panel                                                                                                                                                                                                                                           |
| `kubernetesFeatureToggles`                    | Use the kubernetes API for feature toggle management in the frontend                                                                                                                                                                                                              |
| `newFolderPicker`                             | Enables the nested folder picker without having nested folders enabled                                                                                                                                                                                                            |
| `onPremToCloudMigrationsAlerts`               | Enables the migration of alerts and its child resources to your Grafana Cloud stack. Requires `onPremToCloudMigrations` to be enabled in conjunction.                                                                                                                             |
| `sqlExpressions`                              | Enables using SQL and DuckDB functions as Expressions.                                                                                                                                                                                                                            |
| `nodeGraphDotLayout`                          | Changed the layout algorithm for the node graph                                                                                                                                                                                                                                   |
| `kubernetesAggregator`                        | Enable grafana's embedded kube-aggregator                                                                                                                                                                                                                                         |
| `expressionParser`                            | Enable new expression parser                                                                                                                                                                                                                                                      |
| `disableNumericMetricsSortingInExpressions`   | In server-side expressions, disable the sorting of numeric-kind metrics by their metric name or labels.                                                                                                                                                                           |
| `queryLibrary`                                | Enables Query Library feature in Explore                                                                                                                                                                                                                                          |
| `logsExploreTableDefaultVisualization`        | Sets the logs table as default visualisation in logs explore                                                                                                                                                                                                                      |
| `alertingListViewV2`                          | Enables the new alert list view design                                                                                                                                                                                                                                            |
| `dashboardRestore`                            | Enables deleted dashboard restore feature (backend only)                                                                                                                                                                                                                          |
| `alertingCentralAlertHistory`                 | Enables the new central alert history.                                                                                                                                                                                                                                            |
| `failWrongDSUID`                              | Throws an error if a datasource has an invalid UIDs                                                                                                                                                                                                                               |
| `alertingApiServer`                           | Register Alerting APIs with the K8s API server                                                                                                                                                                                                                                    |
| `dashboardRestoreUI`                          | Enables the frontend to be able to restore a recently deleted dashboard                                                                                                                                                                                                           |
| `dataplaneAggregator`                         | Enable grafana dataplane aggregator                                                                                                                                                                                                                                               |
| `newFiltersUI`                                | Enables new combobox style UI for the Ad hoc filters variable in scenes architecture                                                                                                                                                                                              |
| `lokiSendDashboardPanelNames`                 | Send dashboard and panel names to Loki when querying                                                                                                                                                                                                                              |
| `alertingPrometheusRulesPrimary`              | Uses Prometheus rules as the primary source of truth for ruler-enabled data sources                                                                                                                                                                                               |
| `singleTopNav`                                | Unifies the top search bar and breadcrumb bar into one                                                                                                                                                                                                                            |
| `exploreLogsShardSplitting`                   | Used in Explore Logs to split queries into multiple queries based on the number of shards                                                                                                                                                                                         |
| `exploreLogsAggregatedMetrics`                | Used in Explore Logs to query by aggregated metrics                                                                                                                                                                                                                               |
| `exploreLogsLimitedTimeRange`                 | Used in Explore Logs to limit the time range                                                                                                                                                                                                                                      |
| `homeSetupGuide`                              | Used in Home for users who want to return to the onboarding flow or quickly find popular config pages                                                                                                                                                                             |
| `appSidecar`                                  | Enable the app sidecar feature that allows rendering 2 apps at the same time                                                                                                                                                                                                      |
| `alertingQueryAndExpressionsStepMode`         | Enables step mode for alerting queries and expressions                                                                                                                                                                                                                            |
| `rolePickerDrawer`                            | Enables the new role picker drawer design                                                                                                                                                                                                                                         |
| `pluginsSriChecks`                            | Enables SRI checks for plugin assets                                                                                                                                                                                                                                              |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode](../#app_mode) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name                    | Description                                                                   |
| -------------------------------------- | ----------------------------------------------------------------------------- |
| `grafanaAPIServerWithExperimentalAPIs` | Register experimental APIs with the k8s API server, including all datasources |
| `grafanaAPIServerEnsureKubectlAccess`  | Start an additional https handler and write kubectl options                   |
| `panelTitleSearchInV1`                 | Enable searching for dashboards using panel title in search v1                |
