import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const getLegendStyles = (theme) => {
  return {
    legend: css({
      fontSize: theme.typography.h3.fontSize,
      fontWeight: theme.typography.fontWeightRegular,
      margin: theme.spacing(0, 0, 2, 0)
    })
  };
};
const Legend = ({ children, className, ...legendProps }) => {
  const styles = useStyles2(getLegendStyles);
  return /* @__PURE__ */ jsx("legend", { className: cx(styles.legend, className), ...legendProps, children });
};

export { Legend, getLegendStyles };
//# sourceMappingURL=Legend.js.map
