import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { InlineSwitch } from '../Switch/Switch.js';
import { InlineField } from '../Forms/InlineField.js';

function AlertingSettings({ options, onOptionsChange }) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("h3", { className: "page-heading", children: "Alerting" }),
    /* @__PURE__ */ jsx("div", { className: "gf-form-group", children: /* @__PURE__ */ jsx("div", { className: "gf-form-inline", children: /* @__PURE__ */ jsx("div", { className: "gf-form", children: /* @__PURE__ */ jsx(
      InlineField,
      {
        labelWidth: 29,
        label: "Manage alert rules in Alerting UI",
        disabled: options.readOnly,
        tooltip: "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source.",
        children: /* @__PURE__ */ jsx(
          InlineSwitch,
          {
            value: options.jsonData.manageAlerts !== false,
            onChange: (event) => onOptionsChange({
              ...options,
              jsonData: { ...options.jsonData, manageAlerts: event.currentTarget.checked }
            })
          }
        )
      }
    ) }) }) })
  ] });
}

export { AlertingSettings };
//# sourceMappingURL=AlertingSettings.js.map
