import { jsxs, jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import { Stack } from '@grafana/ui';
import { promqlGrammar } from '../../promql.js';
import { promQueryModeller } from '../PromQueryModeller.js';
import { buildVisualQueryFromString } from '../parsing.js';
import { OperationExplainedBox } from '../shared/OperationExplainedBox.js';
import { OperationListExplained } from '../shared/OperationListExplained.js';
import { RawQuery } from '../shared/RawQuery.js';

const EXPLAIN_LABEL_FILTER_CONTENT = "Fetch all series matching metric name and label filters.";
const PromQueryBuilderExplained = memo(({ query }) => {
  const visQuery = buildVisualQueryFromString(query || "").query;
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxs(Stack, { gap: 0.5, direction: "column", children: [
    /* @__PURE__ */ jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsx(RawQuery, { query: `${visQuery.metric} ${promQueryModeller.renderLabels(visQuery.labels)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsx(
      OperationListExplained,
      {
        stepNumber: 2,
        queryModeller: promQueryModeller,
        query: visQuery,
        lang
      }
    )
  ] });
});
PromQueryBuilderExplained.displayName = "PromQueryBuilderExplained";

export { EXPLAIN_LABEL_FILTER_CONTENT, PromQueryBuilderExplained };
//# sourceMappingURL=PromQueryBuilderExplained.js.map
