import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import * as React from 'react';
import { useRef, useLayoutEffect } from 'react';
import ReactDOM from 'react-dom';
import '@grafana/data';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

function Portal(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM.createPortal(/* @__PURE__ */ jsx("div", { ref: forwardedRef, children }), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
function PortalContainer() {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { id: "grafana-portal-container", className: styles.grafanaPortalContainer });
}
const getStyles = (theme) => {
  return {
    grafanaPortalContainer: css({
      position: "fixed",
      top: 0,
      width: "100%",
      zIndex: theme.zIndex.portal
    })
  };
};
const RefForwardingPortal = React.forwardRef((props, ref) => {
  return /* @__PURE__ */ jsx(Portal, { ...props, forwardedRef: ref });
});
RefForwardingPortal.displayName = "RefForwardingPortal";

export { Portal, PortalContainer, RefForwardingPortal, getPortalContainer };
//# sourceMappingURL=Portal.js.map
