import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { createSlice } from '@reduxjs/toolkit';
import { useReducer, useEffect } from 'react';
import { config } from '@grafana/runtime';
import { promQueryModeller } from '../PromQueryModeller.js';
import { buildVisualQueryFromString } from '../parsing.js';
import { PromQueryBuilder } from './PromQueryBuilder.js';
import { QueryPreview } from './QueryPreview.js';
import { getSettings } from './metrics-modal/state/state.js';

const prometheusMetricEncyclopedia = config.featureToggles.prometheusMetricEncyclopedia;
function PromQueryBuilderContainer(props) {
  const { query, onChange, onRunQuery, datasource, data, showExplain } = props;
  const [state, dispatch] = useReducer(stateSlice.reducer, { expr: query.expr });
  useEffect(() => {
    var _a, _b, _c, _d;
    dispatch(exprChanged(query.expr));
    if (prometheusMetricEncyclopedia) {
      dispatch(
        setMetricsModalSettings({
          useBackend: (_a = query.useBackend) != null ? _a : false,
          disableTextWrap: (_b = query.disableTextWrap) != null ? _b : false,
          fullMetaSearch: (_c = query.fullMetaSearch) != null ? _c : false,
          includeNullMetadata: (_d = query.includeNullMetadata) != null ? _d : true
        })
      );
    }
  }, [query]);
  useEffect(() => {
    datasource.languageProvider.start(data == null ? void 0 : data.timeRange);
  }, [data == null ? void 0 : data.timeRange, datasource.languageProvider]);
  const onVisQueryChange = (visQuery) => {
    const expr = promQueryModeller.renderQuery(visQuery);
    dispatch(visualQueryChange({ visQuery, expr }));
    if (prometheusMetricEncyclopedia) {
      const metricsModalSettings = getSettings(visQuery);
      onChange({ ...props.query, expr, ...metricsModalSettings });
    } else {
      onChange({ ...props.query, expr });
    }
  };
  if (!state.visQuery) {
    return null;
  }
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      PromQueryBuilder,
      {
        query: state.visQuery,
        datasource,
        onChange: onVisQueryChange,
        onRunQuery,
        data,
        showExplain
      }
    ),
    /* @__PURE__ */ jsx(QueryPreview, { query: query.expr })
  ] });
}
const initialState = {
  expr: ""
};
const stateSlice = createSlice({
  name: "prom-builder-container",
  initialState,
  reducers: {
    visualQueryChange: (state, action) => {
      state.expr = action.payload.expr;
      state.visQuery = action.payload.visQuery;
    },
    exprChanged: (state, action) => {
      var _a;
      if (!state.visQuery || state.expr !== action.payload) {
        state.expr = action.payload;
        const parseResult = buildVisualQueryFromString((_a = action.payload) != null ? _a : "");
        state.visQuery = parseResult.query;
      }
    },
    setMetricsModalSettings: (state, action) => {
      if (state.visQuery && prometheusMetricEncyclopedia) {
        state.visQuery.useBackend = action.payload.useBackend;
        state.visQuery.disableTextWrap = action.payload.disableTextWrap;
        state.visQuery.fullMetaSearch = action.payload.fullMetaSearch;
        state.visQuery.includeNullMetadata = action.payload.includeNullMetadata;
      }
    }
  }
});
const { visualQueryChange, exprChanged, setMetricsModalSettings } = stateSlice.actions;

export { PromQueryBuilderContainer };
//# sourceMappingURL=PromQueryBuilderContainer.js.map
