import { GrafanaNotifierType, NotifierDTO } from 'app/types';

export const grafanaAlertNotifiers: Record<GrafanaNotifierType, NotifierDTO> = {
  dingding: {
    type: 'dingding',
    name: 'DingDing',
    heading: 'DingDing settings',
    description: 'Sends HTTP POST request to DingDing',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: 'https://oapi.dingtalk.com/robot/send?access_token=xxxxxxxxx',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Message Type',
        description: '',
        placeholder: '',
        propertyName: 'msgType',
        selectOptions: [
          {
            value: 'link',
            label: 'Link',
          },
          {
            value: 'actionCard',
            label: 'ActionCard',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: 'Custom DingDing message. You can use template variables.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  kafka: {
    type: 'kafka',
    name: 'Kafka REST Proxy',
    heading: 'Kafka settings',
    description: 'Sends notifications to Kafka Rest Proxy',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Kafka REST Proxy',
        description:
          'Hint: If you are directly using v3 APIs hosted on a Confluent Kafka Server, you must append /kafka to the URL here. Example: https://localhost:8082/kafka',
        placeholder: 'http://localhost:8082',
        propertyName: 'kafkaRestProxy',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Topic',
        description: '',
        placeholder: 'topic1',
        propertyName: 'kafkaTopic',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Username',
        description: '',
        placeholder: '',
        propertyName: 'username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'Password',
        description: 'The password to use when making a call to the Kafka REST Proxy',
        placeholder: '',
        propertyName: 'password',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: 'text',
        label: 'API version',
        description: 'The API version to use when contacting the Kafka REST Server. By default v2 will be used.',
        placeholder: '',
        propertyName: 'apiVersion',
        selectOptions: [
          {
            value: 'v2',
            label: 'v2',
          },
          {
            value: 'v3',
            label: 'v3',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Cluster ID',
        description: 'v3 APIs require a clusterID to be specified.',
        placeholder: 'lkc-abcde',
        propertyName: 'kafkaClusterId',
        selectOptions: null,
        showWhen: {
          field: 'apiVersion',
          is: 'v3',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Description',
        description: 'Templated description of the Kafka message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'description',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Details',
        description: 'Custom details to include with the message. You can use template variables.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'details',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  email: {
    type: 'email',
    name: 'Email',
    heading: 'Email settings',
    description: 'Sends notifications using Grafana server configured SMTP settings',
    info: '',
    options: [
      {
        element: 'checkbox',
        inputType: '',
        label: 'Single email',
        description: 'Send a single email to all recipients',
        placeholder: '',
        propertyName: 'singleEmail',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Addresses',
        description: 'You can enter multiple email addresses using a ";", "\\n" or  "," separator',
        placeholder: '',
        propertyName: 'addresses',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description:
          'Optional message. You can use templates to customize this field. Using a custom message will replace the default message',
        placeholder: '',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Subject',
        description: 'Optional subject. You can use templates to customize this field',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'subject',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  pagerduty: {
    type: 'pagerduty',
    name: 'PagerDuty',
    heading: 'PagerDuty settings',
    description: 'Sends notifications to PagerDuty',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Integration Key',
        description: '',
        placeholder: 'Pagerduty Integration Key',
        propertyName: 'integrationKey',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Severity',
        description:
          'Severity of the event. It must be critical, error, warning, info - otherwise, the default is set which is critical. You can use templates',
        placeholder: 'critical',
        propertyName: 'severity',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Class',
        description: "The class/type of the event, for example 'ping failure' or 'cpu load'",
        placeholder: '',
        propertyName: 'class',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Component',
        description: 'Component of the source machine that is responsible for the event, for example mysql or eth0',
        placeholder: 'Grafana',
        propertyName: 'component',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Group',
        description: "Logical grouping of components of a service, for example 'app-stack'",
        placeholder: '',
        propertyName: 'group',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Summary',
        description: 'You can use templates for summary',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'summary',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Source',
        description: 'The unique location of the affected system, preferably a hostname or FQDN. You can use templates',
        placeholder: 'Konrads-MBP',
        propertyName: 'source',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Client',
        description: 'The name of the monitoring client that is triggering this event. You can use templates',
        placeholder: 'Grafana',
        propertyName: 'client',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Client URL',
        description: 'The URL of the monitoring client that is triggering this event. You can use templates',
        placeholder: '{{ .ExternalURL }}',
        propertyName: 'client_url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'key_value_map',
        inputType: 'text',
        label: 'Details',
        description: 'A set of arbitrary key/value pairs that provide further detail about the incident.',
        placeholder: '',
        propertyName: 'details',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  victorops: {
    type: 'victorops',
    name: 'VictorOps',
    heading: 'VictorOps settings',
    description: 'Sends notifications to VictorOps',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: 'VictorOps url',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Message Type',
        description: '',
        placeholder: '',
        propertyName: 'messageType',
        selectOptions: [
          {
            value: 'CRITICAL',
            label: 'CRITICAL',
          },
          {
            value: 'WARNING',
            label: 'WARNING',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title to display',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Description',
        description: 'Templated description of the message',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'description',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  pushover: {
    type: 'pushover',
    name: 'Pushover',
    heading: 'Pushover settings',
    description: 'Sends HTTP POST request to the Pushover API',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'API Token',
        description: '',
        placeholder: 'Application token',
        propertyName: 'apiToken',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'User key(s)',
        description: '',
        placeholder: 'comma-separated list',
        propertyName: 'userKey',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Device(s) (optional)',
        description: '',
        placeholder: 'comma-separated list; leave empty to send to all devices',
        propertyName: 'device',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Alerting priority',
        description: '',
        placeholder: '',
        propertyName: 'priority',
        selectOptions: [
          {
            value: '2',
            label: 'Emergency',
          },
          {
            value: '1',
            label: 'High',
          },
          {
            value: '0',
            label: 'Normal',
          },
          {
            value: '-1',
            label: 'Low',
          },
          {
            value: '-2',
            label: 'Lowest',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'OK priority',
        description: '',
        placeholder: '',
        propertyName: 'okPriority',
        selectOptions: [
          {
            value: '2',
            label: 'Emergency',
          },
          {
            value: '1',
            label: 'High',
          },
          {
            value: '0',
            label: 'Normal',
          },
          {
            value: '-1',
            label: 'Low',
          },
          {
            value: '-2',
            label: 'Lowest',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Retry (Only used for Emergency Priority)',
        description:
          'How often (in seconds) the Pushover servers will send the same alerting or OK notification to the user.',
        placeholder: 'minimum 30 seconds',
        propertyName: 'retry',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Expire (Only used for Emergency Priority)',
        description: 'How many seconds the alerting or OK notification will continue to be retried.',
        placeholder: 'maximum 86400 seconds',
        propertyName: 'expire',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Alerting sound',
        description: '',
        placeholder: '',
        propertyName: 'sound',
        selectOptions: [
          {
            value: 'default',
            label: 'Default',
          },
          {
            value: 'pushover',
            label: 'Pushover',
          },
          {
            value: 'bike',
            label: 'Bike',
          },
          {
            value: 'bugle',
            label: 'Bugle',
          },
          {
            value: 'cashregister',
            label: 'Cashregister',
          },
          {
            value: 'classical',
            label: 'Classical',
          },
          {
            value: 'cosmic',
            label: 'Cosmic',
          },
          {
            value: 'falling',
            label: 'Falling',
          },
          {
            value: 'gamelan',
            label: 'Gamelan',
          },
          {
            value: 'incoming',
            label: 'Incoming',
          },
          {
            value: 'intermission',
            label: 'Intermission',
          },
          {
            value: 'magic',
            label: 'Magic',
          },
          {
            value: 'mechanical',
            label: 'Mechanical',
          },
          {
            value: 'pianobar',
            label: 'Pianobar',
          },
          {
            value: 'siren',
            label: 'Siren',
          },
          {
            value: 'spacealarm',
            label: 'Spacealarm',
          },
          {
            value: 'tugboat',
            label: 'Tugboat',
          },
          {
            value: 'alien',
            label: 'Alien',
          },
          {
            value: 'climb',
            label: 'Climb',
          },
          {
            value: 'persistent',
            label: 'Persistent',
          },
          {
            value: 'echo',
            label: 'Echo',
          },
          {
            value: 'updown',
            label: 'Updown',
          },
          {
            value: 'none',
            label: 'None',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'OK sound',
        description: '',
        placeholder: '',
        propertyName: 'okSound',
        selectOptions: [
          {
            value: 'default',
            label: 'Default',
          },
          {
            value: 'pushover',
            label: 'Pushover',
          },
          {
            value: 'bike',
            label: 'Bike',
          },
          {
            value: 'bugle',
            label: 'Bugle',
          },
          {
            value: 'cashregister',
            label: 'Cashregister',
          },
          {
            value: 'classical',
            label: 'Classical',
          },
          {
            value: 'cosmic',
            label: 'Cosmic',
          },
          {
            value: 'falling',
            label: 'Falling',
          },
          {
            value: 'gamelan',
            label: 'Gamelan',
          },
          {
            value: 'incoming',
            label: 'Incoming',
          },
          {
            value: 'intermission',
            label: 'Intermission',
          },
          {
            value: 'magic',
            label: 'Magic',
          },
          {
            value: 'mechanical',
            label: 'Mechanical',
          },
          {
            value: 'pianobar',
            label: 'Pianobar',
          },
          {
            value: 'siren',
            label: 'Siren',
          },
          {
            value: 'spacealarm',
            label: 'Spacealarm',
          },
          {
            value: 'tugboat',
            label: 'Tugboat',
          },
          {
            value: 'alien',
            label: 'Alien',
          },
          {
            value: 'climb',
            label: 'Climb',
          },
          {
            value: 'persistent',
            label: 'Persistent',
          },
          {
            value: 'echo',
            label: 'Echo',
          },
          {
            value: 'updown',
            label: 'Updown',
          },
          {
            value: 'none',
            label: 'None',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: '',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  slack: {
    type: 'slack',
    name: 'Slack',
    heading: 'Slack settings',
    description: 'Sends notifications to Slack',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Recipient',
        description:
          'Specify channel, private group, or IM channel (can be an encoded ID or a name) - required unless you provide a webhook',
        placeholder: '',
        propertyName: 'recipient',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: 'url',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Token',
        description: 'Provide a Slack API token (starts with "xoxb") - required unless you provide a webhook',
        placeholder: '',
        propertyName: 'token',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: 'url',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Username',
        description: "Set the username for the bot's message",
        placeholder: '',
        propertyName: 'username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Icon emoji',
        description: "Provide an emoji to use as the icon for the bot's message. Overrides the icon URL.",
        placeholder: '',
        propertyName: 'icon_emoji',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Icon URL',
        description: "Provide a URL to an image to use as the icon for the bot's message",
        placeholder: '',
        propertyName: 'icon_url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Mention Users',
        description:
          "Mention one or more users (comma separated) when notifying in a channel, by ID (you can copy this from the user's Slack profile)",
        placeholder: '',
        propertyName: 'mentionUsers',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Mention Groups',
        description:
          "Mention one or more groups (comma separated) when notifying in a channel (you can copy this from the group's Slack profile URL)",
        placeholder: '',
        propertyName: 'mentionGroups',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Mention Channel',
        description: 'Mention whole channel or just active members when notifying',
        placeholder: '',
        propertyName: 'mentionChannel',
        selectOptions: [
          {
            value: '',
            label: 'Disabled',
          },
          {
            value: 'here',
            label: 'Every active channel member',
          },
          {
            value: 'channel',
            label: 'Every channel member',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Webhook URL',
        description:
          "Optionally provide a Slack incoming webhook URL for sending messages, in this case the token isn't necessary",
        placeholder: 'Slack incoming webhook URL',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: 'token',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Endpoint URL',
        description:
          'Optionally provide a custom Slack message API endpoint for non-webhook requests, default is https://slack.com/api/chat.postMessage',
        placeholder: 'Slack endpoint url',
        propertyName: 'endpointUrl',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the slack message',
        placeholder: '{{ template "slack.default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Text Body',
        description: 'Body of the slack message',
        placeholder: '{{ template "slack.default.text" . }}',
        propertyName: 'text',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  sensugo: {
    type: 'sensugo',
    name: 'Sensu Go',
    heading: 'Sensu Go Settings',
    description: 'Sends HTTP POST request to a Sensu Go API',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Backend URL',
        description: '',
        placeholder: 'http://sensu-api.local:8080',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'API Key',
        description: 'API key to auth to Sensu Go backend',
        placeholder: '',
        propertyName: 'apikey',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Proxy entity name',
        description: '',
        placeholder: 'default',
        propertyName: 'entity',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Check name',
        description: '',
        placeholder: 'default',
        propertyName: 'check',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Handler',
        description: '',
        placeholder: '',
        propertyName: 'handler',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Namespace',
        description: '',
        placeholder: 'default',
        propertyName: 'namespace',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  teams: {
    type: 'teams',
    name: 'Microsoft Teams',
    heading: 'Teams settings',
    description: 'Sends notifications using Incoming Webhook connector to Microsoft Teams',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: 'Teams incoming webhook url',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the Teams message.',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Section Title',
        description: 'Section title for the Teams message. Leave blank for none.',
        placeholder: '',
        propertyName: 'sectiontitle',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  telegram: {
    type: 'telegram',
    name: 'Telegram',
    heading: 'Telegram API settings',
    description: 'Sends notifications to Telegram',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'BOT API Token',
        description: '',
        placeholder: 'Telegram BOT API Token',
        propertyName: 'bottoken',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Chat ID',
        description: 'Integer Telegram Chat Identifier',
        placeholder: '',
        propertyName: 'chatid',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Parse Mode',
        description: "Mode for parsing entities in the message text. Default is 'HTML'",
        placeholder: '',
        propertyName: 'parse_mode',
        selectOptions: [
          {
            value: 'None',
            label: 'None',
          },
          {
            value: 'HTML',
            label: 'HTML',
          },
          {
            value: 'Markdown',
            label: 'Markdown',
          },
          {
            value: 'MarkdownV2',
            label: 'Markdown V2',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Disable Web Page Preview',
        description: 'Disables link previews for links in this message',
        placeholder: '',
        propertyName: 'disable_web_page_preview',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Protect Content',
        description: 'Protects the contents of the sent message from forwarding and saving',
        placeholder: '',
        propertyName: 'protect_content',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Disable Notification',
        description: 'Sends the message silently. Users will receive a notification with no sound.',
        placeholder: '',
        propertyName: 'disable_notification',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  webhook: {
    type: 'webhook',
    name: 'Webhook',
    heading: 'Webhook settings',
    description: 'Sends HTTP POST request to a URL',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: '',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'HTTP Method',
        description: '',
        placeholder: '',
        propertyName: 'httpMethod',
        selectOptions: [
          {
            value: 'POST',
            label: 'POST',
          },
          {
            value: 'PUT',
            label: 'PUT',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'HTTP Basic Authentication - Username',
        description: '',
        placeholder: '',
        propertyName: 'username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'HTTP Basic Authentication - Password',
        description: '',
        placeholder: '',
        propertyName: 'password',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Authorization Header - Scheme',
        description: 'Optionally provide a scheme for the Authorization Request Header. Default is Bearer.',
        placeholder: 'Bearer',
        propertyName: 'authorization_scheme',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Authorization Header - Credentials',
        description:
          'Credentials for the Authorization Request header. Only one of HTTP Basic Authentication or Authorization Request Header can be set.',
        placeholder: '',
        propertyName: 'authorization_credentials',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Max Alerts',
        description:
          'Max alerts to include in a notification. Remaining alerts in the same batch will be ignored above this number. 0 means no limit.',
        placeholder: '',
        propertyName: 'maxAlerts',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message.',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: 'Custom message. You can use template variables.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  oncall: {
    type: 'oncall',
    name: 'Grafana OnCall',
    heading: 'Grafana OnCall settings',
    description: 'Sends notifications to Grafana OnCall',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: '',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'HTTP Method',
        description: '',
        placeholder: '',
        propertyName: 'httpMethod',
        selectOptions: [
          {
            value: 'POST',
            label: 'POST',
          },
          {
            value: 'PUT',
            label: 'PUT',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'HTTP Basic Authentication - Username',
        description: '',
        placeholder: '',
        propertyName: 'username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'HTTP Basic Authentication - Password',
        description: '',
        placeholder: '',
        propertyName: 'password',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Authorization Header - Scheme',
        description: 'Optionally provide a scheme for the Authorization Request Header. Default is Bearer.',
        placeholder: 'Bearer',
        propertyName: 'authorization_scheme',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Authorization Header - Credentials',
        description:
          'Credentials for the Authorization Request header. Only one of HTTP Basic Authentication or Authorization Request Header can be set.',
        placeholder: '',
        propertyName: 'authorization_credentials',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Max Alerts',
        description:
          'Max alerts to include in a notification. Remaining alerts in the same batch will be ignored above this number. 0 means no limit.',
        placeholder: '',
        propertyName: 'maxAlerts',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message.',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: 'Custom message. You can use template variables.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  wecom: {
    type: 'wecom',
    name: 'WeCom',
    heading: 'WeCom settings',
    description: 'Send alerts generated by Grafana to WeCom',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Webhook URL',
        description: 'Required if using GroupRobot',
        placeholder: 'https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=xxxxxxxx',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: 'secret',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Agent ID',
        description: 'Required if using APIAPP, see https://work.weixin.qq.com/wework_admin/frame#apps create ApiApp',
        placeholder: '1000002',
        propertyName: 'agent_id',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: 'url',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Corp ID',
        description: 'Required if using APIAPP, see https://work.weixin.qq.com/wework_admin/frame#profile',
        placeholder: 'wwxxxxxxxxx',
        propertyName: 'corp_id',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: 'url',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'Secret',
        description: 'Required if using APIAPP',
        placeholder: 'secret',
        propertyName: 'secret',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: 'url',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Message Type',
        description: '',
        placeholder: 'Text',
        propertyName: 'msgtype',
        selectOptions: [
          {
            value: 'text',
            label: 'Text',
          },
          {
            value: 'markdown',
            label: 'Markdown',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: 'Custom WeCom message. You can use template variables.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'To User',
        description: '',
        placeholder: '@all',
        propertyName: 'touser',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  'prometheus-alertmanager': {
    type: 'prometheus-alertmanager',
    name: 'Alertmanager',
    heading: 'Alertmanager Settings',
    description: 'Sends notifications to Alertmanager',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: 'http://localhost:9093',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Basic Auth User',
        description: '',
        placeholder: '',
        propertyName: 'basicAuthUser',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'password',
        label: 'Basic Auth Password',
        description: '',
        placeholder: '',
        propertyName: 'basicAuthPassword',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
    ],
  },
  discord: {
    type: 'discord',
    name: 'Discord',
    heading: 'Discord settings',
    description: 'Sends notifications to Discord',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Message Content',
        description: 'Mention a group using @ or a user using <@ID> when notifying in a channel',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Webhook URL',
        description: '',
        placeholder: 'Discord webhook URL',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Avatar URL',
        description: '',
        placeholder: '',
        propertyName: 'avatar_url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: "Use Discord's Webhook Username",
        description:
          "Use the username configured in Discord's webhook settings. Otherwise, the username will be 'Grafana'",
        placeholder: '',
        propertyName: 'use_discord_username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  googlechat: {
    type: 'googlechat',
    name: 'Google Hangouts Chat',
    heading: 'Google Hangouts Chat settings',
    description: 'Sends notifications to Google Hangouts Chat via webhooks based on the official JSON message format',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'URL',
        description: '',
        placeholder: 'Google Hangouts Chat incoming webhook url',
        propertyName: 'url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  LINE: {
    type: 'LINE',
    name: 'LINE',
    heading: 'LINE notify settings',
    description: 'Send notifications to LINE notify',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Token',
        description: '',
        placeholder: 'LINE notify token key',
        propertyName: 'token',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Description',
        description: 'Templated description of the message',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'description',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  threema: {
    type: 'threema',
    name: 'Threema Gateway',
    heading: 'Threema Gateway settings',
    description: 'Sends notifications to Threema using Threema Gateway (Basic IDs)',
    info: 'Notifications can be configured for any Threema Gateway ID of type "Basic". End-to-End IDs are not currently supported.The Threema Gateway ID can be set up at https://gateway.threema.ch/.',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Gateway ID',
        description: 'Your 8 character Threema Gateway Basic ID (starting with a *).',
        placeholder: '*3MAGWID',
        propertyName: 'gateway_id',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '\\*[0-9A-Z]{7}',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Recipient ID',
        description: 'The 8 character Threema ID that should receive the alerts.',
        placeholder: 'YOUR3MID',
        propertyName: 'recipient_id',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '[0-9A-Z]{8}',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'API Secret',
        description: 'Your Threema Gateway API secret.',
        placeholder: '',
        propertyName: 'api_secret',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Title',
        description: 'Templated title of the message.',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'title',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Description',
        description: 'Templated description of the message.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'description',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  mqtt: {
    type: 'mqtt',
    name: 'MQTT',
    heading: 'MQTT settings',
    description: 'Sends notifications to an MQTT broker',
    info: 'The MQTT notifier sends messages to an MQTT broker. The message is sent to the topic specified in the configuration. ',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Broker URL',
        description: 'The URL of the MQTT broker.',
        placeholder: 'tcp://localhost:1883',
        propertyName: 'brokerUrl',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Topic',
        description: 'The topic to which the message will be sent.',
        placeholder: 'grafana/alerts',
        propertyName: 'topic',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: 'text',
        label: 'Message format',
        description:
          "The format of the message to be sent. If set to 'json', the message will be sent as a JSON object. If set to 'text', the message will be sent as a plain text string. By default json is used.",
        placeholder: 'json',
        propertyName: 'messageFormat',
        selectOptions: [
          {
            value: 'json',
            label: 'json',
          },
          {
            value: 'text',
            label: 'text',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Client ID',
        description: 'The client ID to use when connecting to the MQTT broker. If blank, a random client ID is used.',
        placeholder: '',
        propertyName: 'clientId',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description: '',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Username',
        description: 'The username to use when connecting to the MQTT broker.',
        placeholder: '',
        propertyName: 'username',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Password',
        description: 'The password to use when connecting to the MQTT broker.',
        placeholder: '',
        propertyName: 'password',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'QoS',
        description: 'The quality of service to use when sending the message.',
        placeholder: '',
        propertyName: 'qos',
        selectOptions: [
          {
            value: '0',
            label: 'At most once (0)',
          },
          {
            value: '1',
            label: 'At least once (1)',
          },
          {
            value: '2',
            label: 'Exactly once (2)',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Retain',
        description: 'If set to true, the message will be retained by the broker.',
        placeholder: '',
        propertyName: 'retain',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'subform',
        inputType: '',
        label: 'TLS',
        description: 'TLS configuration options',
        placeholder: '',
        propertyName: 'tlsConfig',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: [
          {
            element: 'checkbox',
            inputType: '',
            label: 'Disable certificate verification',
            description: "Do not verify the broker's certificate chain and host name.",
            placeholder: '',
            propertyName: 'insecureSkipVerify',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: false,
            dependsOn: '',
          },
          {
            element: 'textarea',
            inputType: 'text',
            label: 'CA Certificate',
            description: "Certificate in PEM format to use when verifying the broker's certificate chain.",
            placeholder: '',
            propertyName: 'caCertificate',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: true,
            dependsOn: '',
          },
          {
            element: 'textarea',
            inputType: 'text',
            label: 'Client Certificate',
            description: 'Client certificate in PEM format to use when connecting to the broker.',
            placeholder: '',
            propertyName: 'clientCertificate',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: true,
            dependsOn: '',
          },
          {
            element: 'textarea',
            inputType: 'text',
            label: 'Client Key',
            description: 'Client key in PEM format to use when connecting to the broker.',
            placeholder: '',
            propertyName: 'clientKey',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: true,
            dependsOn: '',
          },
        ],
      },
    ],
  },
  opsgenie: {
    type: 'opsgenie',
    name: 'OpsGenie',
    heading: 'OpsGenie settings',
    description: 'Sends notifications to OpsGenie',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'API Key',
        description: '',
        placeholder: 'OpsGenie API Key',
        propertyName: 'apiKey',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Alert API URL',
        description: '',
        placeholder: 'https://api.opsgenie.com/v2/alerts',
        propertyName: 'apiUrl',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Message',
        description: 'Alert text limited to 130 characters.',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Description',
        description: 'A description of the incident.',
        placeholder: '',
        propertyName: 'description',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Auto close incidents',
        description: 'Automatically close alerts in OpsGenie once the alert goes back to ok.',
        placeholder: '',
        propertyName: 'autoClose',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'checkbox',
        inputType: '',
        label: 'Override priority',
        description: 'Allow the alert priority to be set using the og_priority annotation',
        placeholder: '',
        propertyName: 'overridePriority',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'select',
        inputType: '',
        label: 'Send notification tags as',
        description: 'Send the common annotations to Opsgenie as either Extra Properties, Tags or both',
        placeholder: '',
        propertyName: 'sendTagsAs',
        selectOptions: [
          {
            value: 'tags',
            label: 'Tags',
          },
          {
            value: 'details',
            label: 'Extra Properties',
          },
          {
            value: 'both',
            label: 'Tags & Extra Properties',
          },
        ],
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  webex: {
    type: 'webex',
    name: 'Cisco Webex Teams',
    heading: 'Webex settings',
    description: 'Sends notifications to Cisco Webex Teams',
    info: 'Notifications can be configured for any Cisco Webex Teams',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'Cisco Webex API URL',
        description: "API endpoint at which we'll send webhooks to.",
        placeholder: 'https://api.ciscospark.com/v1/messages',
        propertyName: 'api_url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Room ID',
        description: 'The room ID to send messages to.',
        placeholder: 'GMtOWY0ZGJkNzMyMGFl',
        propertyName: 'room_id',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Bot Token',
        description: 'Non-expiring access token of the bot that will post messages on our behalf.',
        placeholder: 'GMtOWY0ZGJkNzMyMGFl-12535454-123213',
        propertyName: 'bot_token',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: true,
        validationRule: '',
        secure: true,
        dependsOn: '',
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Notification Template',
        description: 'Notification template to use. Markdown is supported.',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
      },
    ],
  },
  sns: {
    type: 'sns',
    name: 'AWS SNS',
    heading: 'Webex settings',
    description: 'Sends notifications to AWS Simple Notification Service',
    info: '',
    options: [
      {
        element: 'input',
        inputType: 'text',
        label: 'The Amazon SNS API URL',
        description: '',
        placeholder: '',
        propertyName: 'api_url',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'subform',
        inputType: '',
        label: 'SigV4 Authentication',
        description: "Configures AWS's Signature Verification 4 signing process to sign requests",
        placeholder: '',
        propertyName: 'sigv4',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: [
          {
            element: 'input',
            inputType: 'text',
            label: 'Region',
            description: 'The AWS region. If blank, the region from the default credentials chain is used.',
            placeholder: '',
            propertyName: 'region',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: false,
            dependsOn: '',
            subformOptions: undefined,
          },
          {
            element: 'input',
            inputType: 'text',
            label: 'Access Key',
            description: 'The AWS API access key.',
            placeholder: '',
            propertyName: 'access_key',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: true,
            dependsOn: '',
            subformOptions: undefined,
          },
          {
            element: 'input',
            inputType: 'text',
            label: 'Secret Key',
            description: 'The AWS API secret key.',
            placeholder: '',
            propertyName: 'secret_key',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: true,
            dependsOn: '',
            subformOptions: undefined,
          },
          {
            element: 'input',
            inputType: 'text',
            label: 'Profile',
            description: 'Named AWS profile used to authenticate',
            placeholder: '',
            propertyName: 'profile',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: false,
            dependsOn: '',
            subformOptions: undefined,
          },
          {
            element: 'input',
            inputType: 'text',
            label: 'Role ARN',
            description: 'AWS Role ARN, an alternative to using AWS API keys',
            placeholder: '',
            propertyName: 'role_arn',
            selectOptions: null,
            showWhen: {
              field: '',
              is: '',
            },
            required: false,
            validationRule: '',
            secure: false,
            dependsOn: '',
            subformOptions: undefined,
          },
        ],
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'SNS topic ARN',
        description:
          "If you don't specify this value, you must specify a value for the phone_number or target_arn. If you are using a FIFO SNS topic you should set a message group interval longer than 5 minutes to prevent messages with the same group key being deduplicated by the SNS default deduplication window.",
        placeholder: '',
        propertyName: 'topic_arn',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Phone number',
        description:
          "Phone number if message is delivered via SMS in E.164 format. If you don't specify this value, you must specify a value for the topic_arn or target_arn",
        placeholder: '',
        propertyName: 'phone_number',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Target ARN',
        description:
          "The mobile platform endpoint ARN if message is delivered via mobile notifications. If you don't specify this value, you must specify a value for the topic_arn or phone_number",
        placeholder: '',
        propertyName: 'target_arn',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'input',
        inputType: 'text',
        label: 'Subject',
        description: 'Optional subject. You can use templates to customize this field',
        placeholder: '{{ template "default.title" . }}',
        propertyName: 'subject',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'textarea',
        inputType: '',
        label: 'Message',
        description:
          'Optional message. You can use templates to customize this field. Using a custom message will replace the default message',
        placeholder: '{{ template "default.message" . }}',
        propertyName: 'message',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
      {
        element: 'key_value_map',
        inputType: 'text',
        label: 'Attributes',
        description: 'SNS message attributes',
        placeholder: '',
        propertyName: 'attributes',
        selectOptions: null,
        showWhen: {
          field: '',
          is: '',
        },
        required: false,
        validationRule: '',
        secure: false,
        dependsOn: '',
        subformOptions: undefined,
      },
    ],
  },
};

export const grafanaAlertNotifiersMock: NotifierDTO[] = Object.values(grafanaAlertNotifiers);
