import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import Skeleton from 'react-loading-skeleton';
import '@grafana/data';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import { attachSkeleton } from '../../utils/skeleton.js';
import '../../utils/dom.js';
import '../../utils/colors.js';
import 'slate';
import { getTagColorsFromName, getTagColor } from '../../utils/tags.js';
import 'lodash';
import 'ansicolor';
import '../../utils/logger.js';
import { Icon } from '../Icon/Icon.js';

const TagComponent = forwardRef(({ name, onClick, icon, className, colorIndex, ...rest }, ref) => {
  const theme = useTheme2();
  const styles = getTagStyles(theme, name, colorIndex);
  const onTagClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    onClick == null ? void 0 : onClick(name, event);
  };
  const classes = cx(styles.wrapper, className, { [styles.hover]: onClick !== void 0 });
  return onClick ? /* @__PURE__ */ jsxs("button", { ...rest, className: classes, onClick: onTagClick, ref, children: [
    icon && /* @__PURE__ */ jsx(Icon, { name: icon }),
    name
  ] }) : /* @__PURE__ */ jsxs("span", { ...rest, className: classes, ref, children: [
    icon && /* @__PURE__ */ jsx(Icon, { name: icon }),
    name
  ] });
});
TagComponent.displayName = "Tag";
const TagSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles);
  return /* @__PURE__ */ jsx(Skeleton, { width: 60, height: 22, containerClassName: styles.container, ...rootProps });
};
const Tag = attachSkeleton(TagComponent, TagSkeleton);
const getSkeletonStyles = () => ({
  container: css({
    lineHeight: 1
  })
});
const getTagStyles = (theme, name, colorIndex) => {
  let colors;
  if (colorIndex === void 0) {
    colors = getTagColorsFromName(name);
  } else {
    colors = getTagColor(colorIndex);
  }
  return {
    wrapper: css({
      appearance: "none",
      borderStyle: "none",
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      lineHeight: theme.typography.bodySmall.lineHeight,
      verticalAlign: "baseline",
      backgroundColor: colors.color,
      color: theme.v1.palette.gray98,
      whiteSpace: "pre",
      textShadow: "none",
      padding: "3px 6px",
      borderRadius: theme.shape.radius.default
    }),
    hover: css({
      "&:hover": {
        opacity: 0.85,
        cursor: "pointer"
      }
    })
  };
};

export { Tag };
//# sourceMappingURL=Tag.js.map
