import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState, useCallback } from 'react';
import { IconButton } from '../IconButton/IconButton.js';
import { Stack } from '../Layout/Stack/Stack.js';
import { TableCellInspector } from './TableCellInspector.js';
import { FILTER_FOR_OPERATOR, FILTER_OUT_OPERATOR } from './types.js';
import { getTextAlign } from './utils.js';

function CellActions({ field, cell, previewMode, showFilters, onCellFilterAdded }) {
  var _a;
  const [isInspecting, setIsInspecting] = useState(false);
  const isRightAligned = getTextAlign(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("div", { className: `cellActions${isRightAligned ? " cellActionsLeft" : ""}`, children: /* @__PURE__ */ jsxs(Stack, { gap: 0.5, children: [
      inspectEnabled && /* @__PURE__ */ jsx(
        IconButton,
        {
          name: "eye",
          tooltip: "Inspect value",
          onClick: () => {
            setIsInspecting(true);
          },
          ...commonButtonProps
        }
      ),
      showFilters && /* @__PURE__ */ jsx(IconButton, { name: "search-plus", onClick: onFilterFor, tooltip: "Filter for value", ...commonButtonProps }),
      showFilters && /* @__PURE__ */ jsx(IconButton, { name: "search-minus", onClick: onFilterOut, tooltip: "Filter out value", ...commonButtonProps })
    ] }) }),
    isInspecting && /* @__PURE__ */ jsx(
      TableCellInspector,
      {
        mode: previewMode,
        value: cell.value,
        onDismiss: () => {
          setIsInspecting(false);
        }
      }
    )
  ] });
}

export { CellActions };
//# sourceMappingURL=CellActions.js.map
