import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import { selectors } from '@grafana/e2e-selectors';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import { getFocusStyles } from '../../themes/mixins.js';
import '../../utils/skeleton.js';
import { clearButtonStyles } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { Icon } from '../Icon/Icon.js';
import { Counter } from './Counter.js';

const Tab = React.forwardRef(
  ({ label, active, icon, onChangeTab, counter, suffix: Suffix, className, href, ...otherProps }, ref) => {
    const tabsStyles = useStyles2(getStyles);
    const clearStyles = useStyles2(clearButtonStyles);
    const content = () => /* @__PURE__ */ jsxs(Fragment, { children: [
      icon && /* @__PURE__ */ jsx(Icon, { name: icon }),
      label,
      typeof counter === "number" && /* @__PURE__ */ jsx(Counter, { value: counter }),
      Suffix && /* @__PURE__ */ jsx(Suffix, { className: tabsStyles.suffix })
    ] });
    const linkClass = cx(clearStyles, tabsStyles.link, active ? tabsStyles.activeStyle : tabsStyles.notActive);
    const commonProps = {
      className: linkClass,
      "data-testid": selectors.components.Tab.title(label),
      ...otherProps,
      onClick: onChangeTab,
      role: "tab",
      "aria-selected": active
    };
    if (href) {
      return /* @__PURE__ */ jsx("div", { className: tabsStyles.item, children: /* @__PURE__ */ jsx(
        "a",
        {
          ...commonProps,
          href,
          ref,
          children: content()
        }
      ) });
    }
    return /* @__PURE__ */ jsx("div", { className: tabsStyles.item, children: /* @__PURE__ */ jsx(
      "button",
      {
        ...commonProps,
        type: "button",
        ref,
        children: content()
      }
    ) });
  }
);
Tab.displayName = "Tab";
const getStyles = (theme) => {
  return {
    item: css({
      listStyle: "none",
      position: "relative",
      display: "flex",
      whiteSpace: "nowrap",
      padding: theme.spacing(0.5)
    }),
    link: css({
      color: theme.colors.text.secondary,
      padding: theme.spacing(1, 1.5, 0.5),
      borderRadius: theme.shape.radius.default,
      display: "block",
      height: "100%",
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:focus-visible": getFocusStyles(theme),
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        right: 0,
        height: "4px",
        borderRadius: theme.shape.radius.default,
        bottom: 0
      }
    }),
    notActive: css({
      "a:hover, &:hover, &:focus": {
        color: theme.colors.text.primary,
        "&::before": {
          backgroundColor: theme.colors.action.hover
        }
      }
    }),
    activeStyle: css({
      label: "activeTabStyle",
      color: theme.colors.text.primary,
      overflow: "hidden",
      "&::before": {
        backgroundImage: theme.colors.gradients.brandHorizontal
      }
    }),
    suffix: css({
      marginLeft: theme.spacing(1)
    })
  };
};

export { Tab };
//# sourceMappingURL=Tab.js.map
