import { CodeEditorSuggestionItemKind } from './types.js';

function findInsertIndex(line) {
  for (let i = line.length - 1; i > 0; i--) {
    const ch = line.charAt(i);
    if (ch === "$") {
      return {
        index: i,
        prefix: line.substring(i)
      };
    }
    if (ch === " " || ch === "	" || ch === '"' || ch === "'") {
      return {
        index: i + 1,
        prefix: line.substring(i + 1)
      };
    }
  }
  return {
    index: 0,
    prefix: line
  };
}
function getCompletionItems(monaco, prefix, suggestions, range) {
  var _a;
  const items = [];
  for (const suggestion of suggestions) {
    if (prefix && !suggestion.label.startsWith(prefix)) {
      continue;
    }
    items.push({
      ...suggestion,
      kind: mapKinds(monaco, suggestion.kind),
      range,
      insertText: (_a = suggestion.insertText) != null ? _a : suggestion.label
    });
  }
  return items;
}
function mapKinds(monaco, sug) {
  switch (sug) {
    case CodeEditorSuggestionItemKind.Method:
      return monaco.languages.CompletionItemKind.Method;
    case CodeEditorSuggestionItemKind.Field:
      return monaco.languages.CompletionItemKind.Field;
    case CodeEditorSuggestionItemKind.Property:
      return monaco.languages.CompletionItemKind.Property;
    case CodeEditorSuggestionItemKind.Constant:
      return monaco.languages.CompletionItemKind.Constant;
    case CodeEditorSuggestionItemKind.Text:
      return monaco.languages.CompletionItemKind.Text;
  }
  return monaco.languages.CompletionItemKind.Text;
}
function registerSuggestions(monaco, language, getSuggestions, modelId) {
  if (!language || !getSuggestions) {
    return void 0;
  }
  return monaco.languages.registerCompletionItemProvider(language, {
    triggerCharacters: ["$"],
    provideCompletionItems: (model, position, context) => {
      if (model.id !== modelId) {
        return void 0;
      }
      const range = {
        startLineNumber: position.lineNumber,
        endLineNumber: position.lineNumber,
        startColumn: position.column,
        endColumn: position.column
      };
      if (context.triggerCharacter === "$") {
        range.startColumn = position.column - 1;
        return {
          suggestions: getCompletionItems(monaco, "$", getSuggestions(), range)
        };
      }
      const currentLine = model.getValueInRange({
        startLineNumber: position.lineNumber,
        startColumn: 1,
        endLineNumber: position.lineNumber,
        endColumn: position.column
      });
      const { index, prefix } = findInsertIndex(currentLine);
      range.startColumn = index + 1;
      const suggestions = getCompletionItems(monaco, prefix, getSuggestions(), range);
      if (suggestions.length) {
        return { suggestions };
      }
      return void 0;
    }
  });
}

export { findInsertIndex, registerSuggestions };
//# sourceMappingURL=suggestions.js.map
