import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import { fieldColorModeRegistry } from '@grafana/data';
import { useTheme2, useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const SeriesIcon = React.memo(
  React.forwardRef(({ color, className, gradient, lineStyle, ...restProps }, ref) => {
    var _a, _b;
    const theme = useTheme2();
    const styles = useStyles2(getStyles);
    let cssColor;
    if (gradient) {
      const colors = (_b = (_a = fieldColorModeRegistry.get(gradient)).getColors) == null ? void 0 : _b.call(_a, theme);
      if (colors == null ? void 0 : colors.length) {
        cssColor = `linear-gradient(90deg, ${colors.join(", ")})`;
      } else {
        cssColor = theme.visualization.getColorByName("");
      }
    } else {
      cssColor = color;
    }
    let customStyle;
    if ((lineStyle == null ? void 0 : lineStyle.fill) === "dot" && !gradient) {
      customStyle = {
        backgroundImage: `radial-gradient(circle at 2px 2px, ${color} 2px, transparent 0)`,
        backgroundSize: "4px 4px",
        backgroundRepeat: "space"
      };
    } else if ((lineStyle == null ? void 0 : lineStyle.fill) === "dash" && !gradient) {
      customStyle = {
        backgroundImage: `linear-gradient(to right, ${color} 100%, transparent 0%)`,
        backgroundSize: "6px 4px",
        backgroundRepeat: "space"
      };
    } else {
      customStyle = {
        background: cssColor,
        borderRadius: theme.shape.radius.pill
      };
    }
    return /* @__PURE__ */ jsx(
      "div",
      {
        "data-testid": "series-icon",
        ref,
        className: cx(className, styles.forcedColors, styles.container),
        style: customStyle,
        ...restProps
      }
    );
  })
);
const getStyles = (theme) => ({
  container: css({
    marginRight: "8px",
    display: "inline-block",
    width: "14px",
    height: "4px"
  }),
  forcedColors: css({
    "@media (forced-colors: active)": {
      forcedColorAdjust: "none"
    }
  })
});
SeriesIcon.displayName = "SeriesIcon";

export { SeriesIcon };
//# sourceMappingURL=SeriesIcon.js.map
