import { jsx } from 'react/jsx-runtime';
import { EditorRow, EditorFieldGroup } from '@grafana/experimental';
import { promqlGrammar } from '../../promql.js';
import { RawQuery } from '../shared/RawQuery.js';

function QueryPreview({ query }) {
  if (!query) {
    return null;
  }
  return /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(EditorFieldGroup, { children: /* @__PURE__ */ jsx(RawQuery, { query, lang: { grammar: promqlGrammar, name: "promql" } }) }) });
}

export { QueryPreview };
//# sourceMappingURL=QueryPreview.js.map
