---
title: Legend options
comments: |
  There are two legend shared files to cover the most common combinations of options. 
  Using two shared files ensures that content remains consistent across visualizations that share the same options and users don't have to figure out which options apply to a specific visualization when reading that content. 
  This file is used in the following visualizations: bar chart, candlestick, histogram, time series, trend, xy chart
---

Legend options control the series names and statistics that appear under or to the right of the graph. For more information about the legend, refer to [Configure a legend](../configure-legend/).

| Option     | Description                                                                                                                                                                                                |
| ---------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Visibility | Toggle the switch to turn the legend on or off.                                                                                                                                                            |
| Mode       | Use these settings to define how the legend appears in your visualization. **List** displays the legend as a list. This is a default display mode of the legend. **Table** displays the legend as a table. |
| Placement  | Choose where to display the legend. **Bottom** places the legend below the graph. **Right** places the legend to the right of the graph.                                                                   |
| Width      | Control how wide the legend is when placed on the right side of the visualization. This option is only displayed if you set the legend placement to **Right**.                                             |
| Values     | Choose which of the [standard calculations](../../query-transform-data/calculation-types/) to show in the legend. You can have more than one.                                                              |
