import { jsxs, jsx } from 'react/jsx-runtime';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';
import { InlineField } from '../Forms/InlineField.js';
import { InlineFieldRow } from '../Forms/InlineFieldRow.js';
import { Input } from '../Input/Input.js';
import { TextArea } from '../TextArea/TextArea.js';

const CertificationKey = ({ hasCert, label, onChange, onClick, placeholder }) => {
  return /* @__PURE__ */ jsxs(InlineFieldRow, { children: [
    /* @__PURE__ */ jsx(InlineField, { label, labelWidth: 14, disabled: hasCert, children: hasCert ? /* @__PURE__ */ jsx(Input, { type: "text", value: "configured", width: 24 }) : /* @__PURE__ */ jsx(TextArea, { rows: 7, onChange, placeholder, required: true }) }),
    hasCert && /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick, style: { marginLeft: 4 }, children: "Reset" })
  ] });
};

export { CertificationKey };
//# sourceMappingURL=CertificationKey.js.map
