import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { FocusScope } from '@react-aria/focus';
import * as React from 'react';
import { Component } from 'react';
import { colorManipulator } from '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { NamedColorsPalette } from './NamedColorsPalette.js';
import SpectrumPalette from './SpectrumPalette.js';

class UnThemedColorPickerPopover extends Component {
  constructor(props) {
    super(props);
    this.getTabClassName = (tabName) => {
      const { activePicker } = this.state;
      return `ColorPickerPopover__tab ${activePicker === tabName && "ColorPickerPopover__tab--active"}`;
    };
    this.handleChange = (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    };
    this.onTabChange = (tab) => {
      return () => this.setState({ activePicker: tab });
    };
    this.renderPicker = () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ jsx(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ jsx(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    };
    this.renderCustomPicker = (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React.createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    };
    this.renderCustomPickerTabs = () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ jsx(Fragment, { children: Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ jsx("button", { className: this.getTabClassName(key), onClick: this.onTabChange(key), type: "button", children: customPickers[key].name }, key);
      }) });
    };
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const styles = getStyles(theme);
    return /* @__PURE__ */ jsx(FocusScope, { contain: true, restoreFocus: true, autoFocus: true, children: /* @__PURE__ */ jsxs("div", { tabIndex: -1, className: styles.colorPickerPopover, children: [
      /* @__PURE__ */ jsxs("div", { className: styles.colorPickerPopoverTabs, children: [
        /* @__PURE__ */ jsx("button", { className: this.getTabClassName("palette"), onClick: this.onTabChange("palette"), type: "button", children: "Colors" }),
        /* @__PURE__ */ jsx("button", { className: this.getTabClassName("spectrum"), onClick: this.onTabChange("spectrum"), type: "button", children: "Custom" }),
        this.renderCustomPickerTabs()
      ] }),
      /* @__PURE__ */ jsx("div", { className: styles.colorPickerPopoverContent, children: this.renderPicker() })
    ] }) });
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles = stylesFactory((theme) => {
  return {
    colorPickerPopover: css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      ".ColorPickerPopover__tab": {
        width: "50%",
        textAlign: "center",
        padding: theme.spacing(1, 0),
        background: theme.colors.background.secondary,
        color: theme.colors.text.secondary,
        fontSize: theme.typography.bodySmall.fontSize,
        cursor: "pointer",
        border: "none",
        "&:focus:not(:focus-visible)": {
          outline: "none",
          boxShadow: "none"
        },
        ":focus-visible": {
          position: "relative"
        }
      },
      ".ColorPickerPopover__tab--active": {
        color: theme.colors.text.primary,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.background.primary
      }
    }),
    colorPickerPopoverContent: css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

export { ColorPickerPopover };
//# sourceMappingURL=ColorPickerPopover.js.map
