import { jsxs, jsx } from 'react/jsx-runtime';
import { Trans } from '../../../utils/i18n.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import { Stack } from '../../Layout/Stack/Stack.js';

function Footer({ onClose, onApply }) {
  return /* @__PURE__ */ jsxs(Stack, { gap: 2, justifyContent: "space-between", children: [
    /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: onClose, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.calendar.cancel-button", children: "Cancel" }) }),
    /* @__PURE__ */ jsx(Button, { onClick: onApply, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.calendar.apply-button", children: "Apply time range" }) })
  ] });
}
Footer.displayName = "Footer";

export { Footer };
//# sourceMappingURL=CalendarFooter.js.map
