import { jsxs, jsx } from 'react/jsx-runtime';
import { isString } from 'lodash';
import { ClipboardButton } from '../ClipboardButton/ClipboardButton.js';
import { Drawer } from '../Drawer/Drawer.js';
import { CodeEditor } from '../Monaco/CodeEditor.js';

function TableCellInspector({ value, onDismiss, mode }) {
  let displayValue = value;
  if (isString(value)) {
    const trimmedValue = value.trim();
    if (trimmedValue[0] === "{" || trimmedValue[0] === "[" || mode === "code") {
      try {
        value = JSON.parse(value);
        mode = "code";
      } catch (e) {
        mode = "text";
      }
    } else {
      mode = "text";
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  let text = displayValue;
  if (mode === "code") {
    text = JSON.stringify(value, null, " ");
  }
  return /* @__PURE__ */ jsxs(Drawer, { onClose: onDismiss, title: "Inspect value", children: [
    mode === "code" ? /* @__PURE__ */ jsx(
      CodeEditor,
      {
        width: "100%",
        height: 500,
        language: "json",
        showLineNumbers: true,
        showMiniMap: (text && text.length) > 100,
        value: text,
        readOnly: true
      }
    ) : /* @__PURE__ */ jsx("pre", { children: text }),
    /* @__PURE__ */ jsx(ClipboardButton, { icon: "copy", getText: () => text, children: "Copy to Clipboard" })
  ] });
}

export { TableCellInspector };
//# sourceMappingURL=TableCellInspector.js.map
