import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

const ErrorWithStack = ({ error, errorInfo, title }) => {
  const style = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: style, children: [
    /* @__PURE__ */ jsx("h2", { children: title }),
    /* @__PURE__ */ jsxs("details", { style: { whiteSpace: "pre-wrap" }, children: [
      error && error.toString(),
      /* @__PURE__ */ jsx("br", {}),
      errorInfo && errorInfo.componentStack
    ] })
  ] });
};
ErrorWithStack.displayName = "ErrorWithStack";
const getStyles = () => {
  return css({
    width: "500px",
    margin: "64px auto"
  });
};

export { ErrorWithStack };
//# sourceMappingURL=ErrorWithStack.js.map
