import { isValidDuration, parseDuration, durationToMilliseconds, dateTime, incrRoundDn, amendTable, trimTable } from '@grafana/data';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const defaultPrometheusQueryOverlapWindow = "10m";
const getFieldIdent = (field) => {
  var _a;
  return `${field.type}|${field.name}|${JSON.stringify((_a = field.labels) != null ? _a : "")}`;
};
class QueryCache {
  constructor(options) {
    __publicField(this, "overlapWindowMs");
    __publicField(this, "getTargetSignature");
    __publicField(this, "cache", /* @__PURE__ */ new Map());
    const unverifiedOverlap = options.overlapString;
    if (isValidDuration(unverifiedOverlap)) {
      const duration = parseDuration(unverifiedOverlap);
      this.overlapWindowMs = durationToMilliseconds(duration);
    } else {
      const duration = parseDuration(defaultPrometheusQueryOverlapWindow);
      this.overlapWindowMs = durationToMilliseconds(duration);
    }
    this.getTargetSignature = options.getTargetSignature;
  }
  // can be used to change full range request to partial, split into multiple requests
  requestInfo(request) {
    var _a, _b, _c;
    const newFrom = request.range.from.valueOf();
    const newTo = request.range.to.valueOf();
    const shouldCache = ((_b = (_a = request.rangeRaw) == null ? void 0 : _a.to) == null ? void 0 : _b.toString()) === "now";
    let doPartialQuery = shouldCache;
    let prevTo = void 0;
    const reqTargSigs = /* @__PURE__ */ new Map();
    request.targets.forEach((targ) => {
      let targIdent = `${request.dashboardUID}|${request.panelId}|${targ.refId}`;
      let targSig = this.getTargetSignature(request, targ);
      reqTargSigs.set(targIdent, targSig);
    });
    for (const [targIdent, targSig] of reqTargSigs) {
      let cached = this.cache.get(targIdent);
      let cachedSig = cached == null ? void 0 : cached.sig;
      if (cachedSig !== targSig) {
        doPartialQuery = false;
      } else {
        prevTo = (_c = cached == null ? void 0 : cached.prevTo) != null ? _c : Infinity;
        doPartialQuery = newTo > prevTo && newFrom <= prevTo;
      }
      if (!doPartialQuery) {
        break;
      }
    }
    if (doPartialQuery && prevTo) {
      let newFromPartial = Math.max(prevTo - this.overlapWindowMs, newFrom);
      const newToDate = dateTime(newTo);
      const newFromPartialDate = dateTime(incrRoundDn(newFromPartial, request.intervalMs));
      request = __spreadProps(__spreadValues({}, request), {
        range: __spreadProps(__spreadValues({}, request.range), {
          from: newFromPartialDate,
          to: newToDate
        })
      });
    } else {
      reqTargSigs.forEach((targSig, targIdent) => {
        this.cache.delete(targIdent);
      });
    }
    return {
      requests: [request],
      targSigs: reqTargSigs,
      shouldCache
    };
  }
  // should amend existing cache with new frames and return full response
  procFrames(request, requestInfo, respFrames) {
    if (requestInfo == null ? void 0 : requestInfo.shouldCache) {
      const newFrom = request.range.from.valueOf();
      const newTo = request.range.to.valueOf();
      const respByTarget = /* @__PURE__ */ new Map();
      respFrames.forEach((frame) => {
        let targIdent = `${request.dashboardUID}|${request.panelId}|${frame.refId}`;
        let frames = respByTarget.get(targIdent);
        if (!frames) {
          frames = [];
          respByTarget.set(targIdent, frames);
        }
        frames.push(frame);
      });
      let outFrames = [];
      respByTarget.forEach((respFrames2, targIdent) => {
        var _a, _b;
        let cachedFrames = (_b = targIdent ? (_a = this.cache.get(targIdent)) == null ? void 0 : _a.frames : null) != null ? _b : [];
        respFrames2.forEach((respFrame) => {
          if (respFrame.length === 0 || respFrame.fields.length === 0) {
            return;
          }
          let respFrameIdent = getFieldIdent(respFrame.fields[1]);
          let cachedFrame = cachedFrames.find((cached) => getFieldIdent(cached.fields[1]) === respFrameIdent);
          if (!cachedFrame) {
            cachedFrames.push(respFrame);
          } else {
            let prevTable = cachedFrame.fields.map((field) => field.values);
            let nextTable = respFrame.fields.map((field) => field.values);
            let amendedTable = amendTable(prevTable, nextTable);
            if (amendedTable) {
              for (let i = 0; i < amendedTable.length; i++) {
                cachedFrame.fields[i].values = amendedTable[i];
              }
              cachedFrame.length = cachedFrame.fields[0].values.length;
            }
          }
        });
        let nonEmptyCachedFrames = [];
        cachedFrames.forEach((frame) => {
          let table = frame.fields.map((field) => field.values);
          let trimmed = trimTable(table, newFrom, newTo);
          if (trimmed[0].length > 0) {
            for (let i = 0; i < trimmed.length; i++) {
              frame.fields[i].values = trimmed[i];
            }
            nonEmptyCachedFrames.push(frame);
          }
        });
        this.cache.set(targIdent, {
          sig: requestInfo.targSigs.get(targIdent),
          frames: nonEmptyCachedFrames,
          prevTo: newTo
        });
        outFrames.push(...nonEmptyCachedFrames);
      });
      respFrames = outFrames.map((frame) => __spreadProps(__spreadValues({}, frame), {
        fields: frame.fields.map((field) => __spreadProps(__spreadValues({}, field), {
          config: __spreadValues({}, field.config),
          values: field.values.slice()
        }))
      }));
    }
    return respFrames;
  }
}

export { QueryCache, defaultPrometheusQueryOverlapWindow, getFieldIdent };
//# sourceMappingURL=QueryCache.js.map
