import { jsxs, jsx } from 'react/jsx-runtime';
import { reportInteraction } from '@grafana/runtime';
import { useTheme2, Button, Tooltip } from '@grafana/ui';
import { getStyles } from './PromQail.js';
import AI_Logo_color from './resources/AI_Logo_color.svg.js';
import { selectors } from '../../../grafana-e2e-selectors/src/selectors/index.js';

function QueryAssistantButton(props) {
  const { llmAppEnabled, metric, setShowDrawer } = props;
  const llmAppDisabled = !llmAppEnabled;
  const noMetricSelected = !metric;
  const theme = useTheme2();
  const styles = getStyles(theme);
  const button = () => {
    return /* @__PURE__ */ jsxs(
      Button,
      {
        variant: "secondary",
        onClick: () => {
          reportInteraction("grafana_prometheus_promqail_ai_button_clicked", {
            metric
          });
          setShowDrawer(true);
        },
        disabled: !metric || !llmAppEnabled,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.builder.queryAdvisor,
        children: [
          /* @__PURE__ */ jsx("img", { height: 16, src: AI_Logo_color, alt: "AI logo black and white" }),
          "\xA0",
          "Get query suggestions"
        ]
      }
    );
  };
  const selectMetricMessage = /* @__PURE__ */ jsx(Tooltip, { content: "First, select a metric.", placement: "bottom-end", children: button() });
  const llmAppMessage = /* @__PURE__ */ jsx(
    Tooltip,
    {
      interactive: true,
      placement: "auto-end",
      content: /* @__PURE__ */ jsxs("div", { className: styles.enableButtonTooltip, children: [
        /* @__PURE__ */ jsx("h6", { children: "Query Advisor is disabled" }),
        /* @__PURE__ */ jsx("div", { className: styles.enableButtonTooltipText, children: "To enable Query Advisor you must:" }),
        /* @__PURE__ */ jsx("div", { className: styles.enableButtonTooltipText, children: /* @__PURE__ */ jsxs("ul", { children: [
          /* @__PURE__ */ jsx("li", { children: /* @__PURE__ */ jsx(
            "a",
            {
              href: "https://grafana.com/docs/grafana-cloud/alerting-and-irm/machine-learning/llm-plugin/",
              target: "_blank",
              rel: "noreferrer noopener",
              className: styles.link,
              children: "Install and enable the LLM plugin"
            }
          ) }),
          /* @__PURE__ */ jsx("li", { children: "Select a metric" })
        ] }) })
      ] }),
      children: button()
    }
  );
  if (llmAppDisabled) {
    return llmAppMessage;
  } else if (noMetricSelected) {
    return selectMetricMessage;
  } else {
    return button();
  }
}

export { QueryAssistantButton };
//# sourceMappingURL=QueryAssistantButton.js.map
