import { jsx } from 'react/jsx-runtime';
import WKT from 'ol/format/WKT';
import { Geometry } from 'ol/geom';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function GeoCell(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof Geometry) {
    disp = new WKT().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ jsx("div", __spreadProps(__spreadValues({}, cellProps), { className: tableStyles.cellContainer, children: /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" }, children: disp }) }));
}

export { GeoCell };
//# sourceMappingURL=GeoCell.js.map
