import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { DragDropContext, Droppable } from '@hello-pangea/dnd';
import { cloneDeep } from 'lodash';
import { useState, useEffect } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';
import { Button } from '../../Button/Button.js';
import '../../Button/ButtonGroup.js';
import { Modal } from '../../Modal/Modal.js';
import { DataLinkEditorModalContent } from './DataLinkEditorModalContent.js';
import { DataLinksListItem } from './DataLinksListItem.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const DataLinksInlineEditor = ({
  links,
  onChange,
  getSuggestions,
  data,
  showOneClick = false
}) => {
  const [editIndex, setEditIndex] = useState(null);
  const [isNew, setIsNew] = useState(false);
  const [linksSafe, setLinksSafe] = useState([]);
  useEffect(() => {
    setLinksSafe(links != null ? links : []);
  }, [links]);
  const styles = useStyles2(getDataLinksInlineEditorStyles);
  const isEditing = editIndex !== null;
  const onDataLinkChange = (index, link) => {
    if (isNew) {
      if (link.title.trim() === "" && link.url.trim() === "") {
        setIsNew(false);
        setEditIndex(null);
        return;
      } else {
        setEditIndex(null);
        setIsNew(false);
      }
    }
    const update = cloneDeep(linksSafe);
    update[index] = link;
    onChange(update);
    setEditIndex(null);
  };
  const onDataLinkAdd = () => {
    let update = cloneDeep(linksSafe);
    setEditIndex(update.length);
    setIsNew(true);
  };
  const onDataLinkCancel = (index) => {
    if (isNew) {
      setIsNew(false);
    }
    setEditIndex(null);
  };
  const onDataLinkRemove = (index) => {
    const update = cloneDeep(linksSafe);
    update.splice(index, 1);
    onChange(update);
  };
  const onDragEnd = (result) => {
    if (!links || !result.destination) {
      return;
    }
    const update = cloneDeep(linksSafe);
    const link = update[result.source.index];
    update.splice(result.source.index, 1);
    update.splice(result.destination.index, 0, link);
    setLinksSafe(update);
    onChange(update);
  };
  const renderFirstLink = (linkJSX, key) => {
    if (showOneClick) {
      return /* @__PURE__ */ jsxs("div", { className: styles.oneClickOverlay, children: [
        /* @__PURE__ */ jsx("span", { className: styles.oneClickSpan, children: "One-click link" }),
        linkJSX
      ] }, key);
    }
    return linkJSX;
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(DragDropContext, { onDragEnd, children: /* @__PURE__ */ jsx(Droppable, { droppableId: "sortable-links", direction: "vertical", children: (provided) => /* @__PURE__ */ jsxs("div", __spreadProps(__spreadValues({ className: styles.wrapper, ref: provided.innerRef }, provided.droppableProps), { children: [
      linksSafe.map((link, idx) => {
        const key = `${link.title}/${idx}`;
        const linkJSX = /* @__PURE__ */ jsx("div", { className: styles.itemWrapper, children: /* @__PURE__ */ jsx(
          DataLinksListItem,
          {
            index: idx,
            link,
            onChange: onDataLinkChange,
            onEdit: () => setEditIndex(idx),
            onRemove: () => onDataLinkRemove(idx),
            data,
            itemKey: key
          },
          key
        ) }, key);
        if (idx === 0) {
          return renderFirstLink(linkJSX, key);
        }
        return linkJSX;
      }),
      provided.placeholder
    ] })) }) }),
    isEditing && editIndex !== null && /* @__PURE__ */ jsx(
      Modal,
      {
        title: "Edit link",
        isOpen: true,
        closeOnBackdropClick: false,
        onDismiss: () => {
          onDataLinkCancel();
        },
        children: /* @__PURE__ */ jsx(
          DataLinkEditorModalContent,
          {
            index: editIndex,
            link: isNew ? { title: "", url: "" } : linksSafe[editIndex],
            data,
            onSave: onDataLinkChange,
            onCancel: onDataLinkCancel,
            getSuggestions
          }
        )
      }
    ),
    /* @__PURE__ */ jsx(Button, { size: "sm", icon: "plus", onClick: onDataLinkAdd, variant: "secondary", className: styles.button, children: "Add link" })
  ] });
};
const getDataLinksInlineEditorStyles = (theme) => ({
  wrapper: css({
    marginBottom: theme.spacing(2),
    display: "flex",
    flexDirection: "column"
  }),
  oneClickOverlay: css({
    height: "auto",
    border: `2px dashed ${theme.colors.text.link}`,
    fontSize: 10,
    color: theme.colors.text.primary,
    marginBottom: theme.spacing(1)
  }),
  oneClickSpan: css({
    padding: 10,
    // Negates the padding on the span from moving the underlying link
    marginBottom: -10,
    display: "inline-block"
  }),
  itemWrapper: css({
    padding: "4px 8px 8px 8px"
  }),
  button: css({
    marginLeft: theme.spacing(1)
  })
});

export { DataLinksInlineEditor };
//# sourceMappingURL=DataLinksInlineEditor.js.map
