import { Label, Spinner, Stack, Switch } from '@grafana/ui';

import { t, Trans } from '../../../core/internationalization';
import { ThemePicker } from '../../dashboard/components/ShareModal/ThemePicker';

interface Props {
  useLockedTime: boolean;
  onToggleLockedTime: () => void;
  useShortUrl: boolean;
  onUrlShorten: () => void;
  selectedTheme: string;
  onChangeTheme: (v: string) => void;
  isLoading: boolean;
}

export default function ShareInternallyConfiguration({
  useLockedTime,
  onToggleLockedTime,
  useShortUrl,
  onUrlShorten,
  onChangeTheme,
  selectedTheme,
  isLoading,
}: Props) {
  return (
    <Stack justifyContent="space-between">
      <Stack gap={2} direction="column">
        <Stack gap={1} direction="column">
          <Stack gap={1} alignItems="start">
            <Switch
              label={t('link.share.time-range-label', 'Lock time range')}
              id="share-current-time-range"
              value={useLockedTime}
              onChange={onToggleLockedTime}
            />
            <Label
              description={t(
                'link.share.time-range-description',
                'Change the current relative time range to an absolute time range'
              )}
            >
              <Trans i18nKey="link.share.time-range-label">Lock time range</Trans>
            </Label>
          </Stack>
          <Stack gap={1} alignItems="start">
            <Switch
              id="share-short-url"
              value={useShortUrl}
              label={t('link.share.short-url-label', 'Shorten link')}
              onChange={onUrlShorten}
            />
            <Label>
              <Trans i18nKey="link.share.short-url-label">Shorten link</Trans>
            </Label>
          </Stack>
        </Stack>
        <ThemePicker selectedTheme={selectedTheme} onChange={onChangeTheme} />
      </Stack>
      {isLoading && <Spinner />}
    </Stack>
  );
}
