import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const RadioButtonDot = (_a) => {
  var _b = _a, {
    id,
    name,
    label,
    checked,
    value,
    disabled,
    description,
    onChange
  } = _b, props = __objRest(_b, [
    "id",
    "name",
    "label",
    "checked",
    "value",
    "disabled",
    "description",
    "onChange"
  ]);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("label", { title: description, className: styles.label, children: [
    /* @__PURE__ */ jsx(
      "input",
      __spreadProps(__spreadValues({}, props), {
        id,
        name,
        type: "radio",
        checked,
        value,
        disabled,
        className: styles.input,
        onChange: () => onChange && onChange(id)
      })
    ),
    /* @__PURE__ */ jsxs("div", { children: [
      label,
      description && /* @__PURE__ */ jsx("div", { className: styles.description, children: description })
    ] })
  ] });
};
const getStyles = (theme) => ({
  input: css({
    position: "relative",
    appearance: "none",
    outline: "none",
    backgroundColor: theme.colors.background.canvas,
    width: `${theme.spacing(2)} !important`,
    height: theme.spacing(2),
    border: `1px solid ${theme.colors.border.medium}`,
    borderRadius: theme.shape.radius.circle,
    margin: "3px 0",
    ":checked": {
      backgroundColor: theme.v1.palette.white,
      border: `5px solid ${theme.colors.primary.main}`
    },
    ":disabled": {
      backgroundColor: `${theme.colors.action.disabledBackground} !important`,
      borderColor: theme.colors.border.weak
    },
    ":disabled:checked": {
      border: `1px solid ${theme.colors.border.weak}`
    },
    ":disabled:checked::after": {
      content: '""',
      width: "6px",
      height: "6px",
      backgroundColor: theme.colors.text.disabled,
      borderRadius: theme.shape.radius.circle,
      display: "inline-block",
      position: "absolute",
      top: "4px",
      left: "4px"
    },
    ":focus": {
      outline: "none !important",
      boxShadow: `0 0 0 1px ${theme.colors.background.canvas}, 0 0 0 3px ${theme.colors.primary.main}`
    }
  }),
  label: css({
    fontSize: theme.typography.fontSize,
    lineHeight: "22px",
    display: "grid",
    gridTemplateColumns: `${theme.spacing(2)} auto`,
    gap: theme.spacing(1)
  }),
  description: css({
    fontSize: theme.typography.size.sm,
    color: theme.colors.text.secondary
  })
});

export { RadioButtonDot };
//# sourceMappingURL=RadioButtonDot.js.map
