import { jsx, Fragment, jsxs } from 'react/jsx-runtime';
import { createElement } from 'react';
import { cx, css } from '@emotion/css';
import { Draggable } from '@hello-pangea/dnd';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';
import '../../../utils/dom.js';
import '../../../utils/colors.js';
import 'slate';
import { isCompactUrl } from '../../../utils/dataLinks.js';
import 'lodash';
import 'ansicolor';
import '../../../utils/logger.js';
import { FieldValidationMessage } from '../../Forms/FieldValidationMessage.js';
import { Icon } from '../../Icon/Icon.js';
import { IconButton } from '../../IconButton/IconButton.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
const DataLinksListItem = ({ link, onEdit, onRemove, index, itemKey }) => {
  const styles = useStyles2(getDataLinkListItemStyles);
  const { title = "", url = "" } = link;
  const hasTitle = title.trim() !== "";
  const hasUrl = url.trim() !== "";
  const isCompactExploreUrl = isCompactUrl(url);
  return /* @__PURE__ */ jsx(Draggable, { draggableId: itemKey, index, children: (provided) => /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ createElement(
    "div",
    __spreadProps(__spreadValues({
      className: cx(styles.wrapper, styles.dragRow),
      ref: provided.innerRef
    }, provided.draggableProps), {
      key: index
    }),
    /* @__PURE__ */ jsxs("div", { className: styles.linkDetails, children: [
      /* @__PURE__ */ jsx("div", { className: cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored), children: hasTitle ? title : "Data link title not provided" }),
      /* @__PURE__ */ jsx(
        "div",
        {
          className: cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored),
          title: url,
          children: hasUrl ? url : "Data link url not provided"
        }
      ),
      isCompactExploreUrl && /* @__PURE__ */ jsx(FieldValidationMessage, { children: "Explore data link may not work in the future. Please edit." })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles.icons, children: [
      /* @__PURE__ */ jsx(IconButton, { name: "pen", onClick: onEdit, className: styles.icon, tooltip: "Edit data link" }),
      /* @__PURE__ */ jsx(IconButton, { name: "trash-alt", onClick: onRemove, className: styles.icon, tooltip: "Remove data link" }),
      /* @__PURE__ */ jsx("div", __spreadProps(__spreadValues({ className: styles.dragIcon }, provided.dragHandleProps), { children: /* @__PURE__ */ jsx(Icon, { name: "draggabledots", size: "lg" }) }))
    ] })
  ) }) }, itemKey);
};
const getDataLinkListItemStyles = (theme) => {
  return {
    wrapper: css({
      display: "flex",
      flexGrow: 1,
      alignItems: "center",
      justifyContent: "space-between",
      width: "100%",
      padding: "5px 0 5px 10px",
      borderRadius: theme.shape.radius.default,
      background: theme.colors.background.secondary,
      gap: 8
    }),
    linkDetails: css({
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      maxWidth: `calc(100% - 100px)`
    }),
    errored: css({
      color: theme.colors.error.text,
      fontStyle: "italic"
    }),
    notConfigured: css({
      fontStyle: "italic"
    }),
    title: css({
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    }),
    url: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    dragRow: css({
      position: "relative"
    }),
    icons: css({
      display: "flex",
      padding: 6,
      alignItems: "center",
      gap: 8
    }),
    dragIcon: css({
      cursor: "grab",
      color: theme.colors.text.secondary,
      margin: theme.spacing(0, 0.5)
    }),
    icon: css({
      color: theme.colors.text.secondary
    })
  };
};

export { DataLinksListItem };
//# sourceMappingURL=DataLinksListItem.js.map
