import React, { useState } from 'react';

import { Box, Button, Text } from '@grafana/ui';
import { Trans } from 'app/core/internationalization';

import { useCreateMigrationMutation } from '../../../api';

import { ConnectModal } from './ConnectModal';

export const CallToAction = () => {
  const [modalOpen, setModalOpen] = useState(false);
  const [createMigration, createMigrationResponse] = useCreateMigrationMutation();

  return (
    <>
      <Box display="flex" padding={5} gap={2} direction="column" alignItems="center" backgroundColor="secondary">
        <Text variant="h3" textAlignment="center">
          <Trans i18nKey="migrate-to-cloud.cta.header">Let us manage your Grafana stack</Trans>
        </Text>

        <Button disabled={createMigrationResponse.isLoading} onClick={() => setModalOpen(true)}>
          <Trans i18nKey="migrate-to-cloud.cta.button">Migrate this instance to Cloud</Trans>
        </Button>
      </Box>

      <ConnectModal
        isOpen={modalOpen}
        isLoading={createMigrationResponse.isLoading}
        isError={createMigrationResponse.isError}
        onConfirm={createMigration}
        hideModal={() => setModalOpen(false)}
      />
    </>
  );
};
